/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.EntityProximitySpawner;
import thebetweenlands.common.entity.projectiles.EntitySludgeWallJet;

public class EntityTriggeredSludgeWallJet
extends EntityProximitySpawner {
    private static final DataParameter<Integer> ANIMATION_TICKS_SYNC = EntityDataManager.func_187226_a(EntityTriggeredSludgeWallJet.class, (DataSerializer)DataSerializers.field_187192_b);
    public int animationTicks = 0;
    public int animationTicksPrev = 0;

    public EntityTriggeredSludgeWallJet(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.func_189654_d(true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANIMATION_TICKS_SYNC, (Object)0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.func_70107_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v);
        return super.func_180482_a(difficulty, livingdata);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K && this.field_70173_aa % 40 == 0) {
            this.checkArea();
        }
        this.animationTicksPrev = this.animationTicks++;
        this.field_70177_z = this.field_70761_aq = (float)MathHelper.func_188209_b((int)this.animationTicks);
        if (!this.func_130014_f_().field_72995_K && this.field_70173_aa % 20 == 0) {
            this.field_70180_af.func_187227_b(ANIMATION_TICKS_SYNC, (Object)this.animationTicks);
        }
        if (this.animationTicks >= 360) {
            this.animationTicksPrev = 0;
            this.animationTicks = 0;
        }
        if (this.func_130014_f_().field_72995_K) {
            this.spawnCloudParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnCloudParticles() {
        if (this.field_70146_Z.nextInt(4) == 0) {
            Object args = ParticleFactory.ParticleArgs.get().withDataBuilder().setData(2, this).buildData();
            ((ParticleFactory.ParticleArgs)args).withColor(1.0f, 0.65f, 0.25f, 0.75f);
            ((ParticleFactory.ParticleArgs)args).withScale(1.5f + this.field_70146_Z.nextFloat() * 6.0f);
            BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_NEAREST_NEIGHBOR, BLParticles.SLUDGE_SWIRL.create(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (ParticleFactory.ParticleArgs<?>)args));
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (this.func_130014_f_().field_72995_K && ANIMATION_TICKS_SYNC.equals(key)) {
            this.animationTicks = this.animationTicksPrev = ((Integer)this.field_70180_af.func_187225_a(ANIMATION_TICKS_SYNC)).intValue();
        }
    }

    @Override
    protected void performPreSpawnaction(Entity targetEntity, Entity entitySpawned) {
        if (targetEntity instanceof EntityPlayer) {
            float angle = (float)Math.toDegrees(Math.atan2(targetEntity.field_70165_t - this.field_70165_t, targetEntity.field_70161_v - this.field_70161_v));
            float angleDiff = Math.abs(MathHelper.func_76142_g((float)(MathHelper.func_76142_g((float)angle) - MathHelper.func_76142_g((float)(-this.field_70177_z)))));
            if (angleDiff < 55.0f) {
                ((EntitySludgeWallJet)entitySpawned).func_70106_y();
            } else {
                ((EntitySludgeWallJet)entitySpawned).func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v);
                ((EntitySludgeWallJet)entitySpawned).func_70186_c(targetEntity.field_70165_t - this.field_70165_t, targetEntity.field_70163_u + (double)targetEntity.field_70131_O - this.field_70163_u, targetEntity.field_70161_v - this.field_70161_v, 0.5f, 0.0f);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        Entity immediateSource;
        if (source instanceof EntityDamageSource && (immediateSource = ((EntityDamageSource)source).func_76364_f()) != null) {
            float angle = (float)Math.toDegrees(Math.atan2(immediateSource.field_70165_t - this.field_70165_t, immediateSource.field_70161_v - this.field_70161_v));
            float angleDiff = Math.abs(MathHelper.func_76142_g((float)(MathHelper.func_76142_g((float)angle) - MathHelper.func_76142_g((float)(-this.field_70177_z)))));
            if (angleDiff < 55.0f) {
                if (!this.func_130014_f_().field_72995_K) {
                    this.func_70665_d(source, 5.0f);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    protected boolean func_70610_aX() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70024_g(double x, double y, double z) {
    }

    public boolean func_190530_aW() {
        return false;
    }

    @Override
    protected float getProximityHorizontal() {
        return 5.0f;
    }

    @Override
    protected float getProximityVertical() {
        return 1.0f;
    }

    @Override
    protected AxisAlignedBB proximityBox() {
        return new AxisAlignedBB(this.func_180425_c()).func_72314_b((double)this.getProximityHorizontal(), (double)this.getProximityVertical(), (double)this.getProximityHorizontal());
    }

    @Override
    protected boolean canSneakPast() {
        return true;
    }

    @Override
    protected boolean checkSight() {
        return true;
    }

    @Override
    protected Entity getEntitySpawned() {
        EntitySludgeWallJet entity = new EntitySludgeWallJet(this.func_130014_f_(), (EntityLiving)this);
        return entity;
    }

    @Override
    protected int getEntitySpawnCount() {
        return 1;
    }

    @Override
    protected boolean isSingleUse() {
        return false;
    }

    @Override
    protected int maxUseCount() {
        return 0;
    }
}

