/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleLightningArc;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityBLLightningBolt
extends EntityLightningBolt
implements IEntityAdditionalSpawnData {
    private static final byte EVENT_STRIKE = 80;
    private BlockPos startPos = BlockPos.field_177992_a;
    private int delay = 60;
    private boolean isFloatingTarget;

    public EntityBLLightningBolt(World world) {
        super(world, 0.0, 0.0, 0.0, true);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70178_ae = true;
    }

    public EntityBLLightningBolt(World world, double x, double y, double z, int delay, boolean isFloatingTarget) {
        super(world, x, y, z, true);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70178_ae = true;
        this.delay = Math.max(8, delay);
        this.startPos = new BlockPos(x, y, z).func_177982_a(world.field_73012_v.nextInt(40) - 20, 80, world.field_73012_v.nextInt(40) - 20);
        this.isFloatingTarget = isFloatingTarget;
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        super.func_70012_b(x, y, z, yaw, pitch);
        if (BlockPos.field_177992_a.equals((Object)this.startPos)) {
            this.startPos = new BlockPos(x, y, z).func_177982_a(this.field_70170_p.field_73012_v.nextInt(40) - 20, 80, this.field_70170_p.field_73012_v.nextInt(40) - 20);
        }
    }

    protected void func_70088_a() {
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 80) {
            BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.BEAM, this.createParticle(new Vec3d((double)((float)this.startPos.func_177958_n() + 0.5f), (double)this.startPos.func_177956_o(), (double)((float)this.startPos.func_177952_p() + 0.5f)), this.func_174791_d()));
            if (this.isFloatingTarget) {
                BlockPos ground = this.field_70170_p.func_175645_m(this.func_180425_c());
                BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.BEAM, this.createParticle(this.func_174791_d(), new Vec3d((double)((float)ground.func_177958_n() + 0.5f), (double)ground.func_177956_o(), (double)((float)ground.func_177952_p() + 0.5f))));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private ParticleLightningArc createParticle(Vec3d start, Vec3d end) {
        ParticleLightningArc particle = (ParticleLightningArc)BLParticles.LIGHTNING_ARC.create(this.field_70170_p, start.field_72450_a, start.field_72448_b, start.field_72449_c, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withColor(0.5f, 0.4f, 1.0f, 0.9f)).withData(end));
        particle.setBaseSize(0.8f);
        particle.setSubdivs(15, 4);
        particle.setOffsets(4.0f, 0.8f);
        particle.setSplits(3);
        particle.setSplitSpeed(0.1f, 0.65f);
        particle.setLengthDecay(0.1f);
        particle.setSizeDecay(0.3f);
        particle.func_187114_a(20);
        return particle;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        this.delay = Math.max(this.delay - 1, 0);
        if (this.delay == 6) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.THUNDER, SoundCategory.WEATHER, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.LIGHTNING, SoundCategory.WEATHER, 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_72960_a((Entity)this, (byte)80);
        } else if (this.delay > 0 && this.delay <= 4) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_175702_c(2);
            } else {
                if (this.delay == 4) {
                    BlockPos blockpos = new BlockPos((Entity)this);
                    if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("doFireTick") && (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) && this.field_70170_p.func_175697_a(blockpos, 10)) {
                        if (this.field_70170_p.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a && Blocks.field_150480_ab.func_176196_c(this.field_70170_p, blockpos)) {
                            this.field_70170_p.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                        }
                        for (int i = 0; i < 4; ++i) {
                            BlockPos blockpos1 = blockpos.func_177982_a(this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1, this.field_70146_Z.nextInt(3) - 1);
                            if (this.field_70170_p.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a || !Blocks.field_150480_ab.func_176196_c(this.field_70170_p, blockpos1)) continue;
                            this.field_70170_p.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
                        }
                    }
                }
                Vec3d start = new Vec3d((double)((float)this.startPos.func_177958_n() + 0.5f), (double)this.startPos.func_177956_o(), (double)this.startPos.func_177952_p());
                Vec3d end = this.func_174791_d();
                Vec3d diff = end.func_178788_d(start);
                Vec3d dir = diff.func_72432_b();
                double length = diff.func_72433_c();
                double range = 5.0;
                int steps = MathHelper.func_76143_f((double)(length / range / 2.0));
                for (int i = 0; i < steps; ++i) {
                    Vec3d checkPos = start.func_178787_e(diff.func_186678_a((double)(1.0f / (float)steps * (float)(i + 1))));
                    List nearbyEntities = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(checkPos.field_72450_a - range, checkPos.field_72448_b - range, checkPos.field_72449_c - range, checkPos.field_72450_a + range, checkPos.field_72448_b + range, checkPos.field_72449_c + range));
                    for (Entity entity : nearbyEntities) {
                        Vec3d entityPos;
                        Vec3d projection;
                        if (entity instanceof EntityLightningBolt || !((projection = start.func_178787_e(dir.func_186678_a(dir.func_72430_b((entityPos = entity.func_174791_d()).func_178788_d(start))))).func_178788_d(entityPos).func_72433_c() < range)) continue;
                        if (entity instanceof EntityItem) {
                            EntityItem entityItem = (EntityItem)entity;
                            ItemStack stack = entityItem.func_92059_d();
                            Item item = stack.func_77973_b();
                            if (item == ItemRegistry.ANGLER_TOOTH_ARROW || item == ItemRegistry.BASILISK_ARROW || item == ItemRegistry.OCTINE_ARROW || item == ItemRegistry.POISONED_ANGLER_TOOTH_ARROW || item == ItemRegistry.SLUDGE_WORM_ARROW) {
                                if (this.field_70170_p.field_73012_v.nextInt(5) != 0) continue;
                                int converted = this.field_70170_p.field_73012_v.nextInt(Math.min(stack.func_190916_E(), 5)) + 1;
                                stack.func_190918_g(converted);
                                if (stack.func_190926_b()) {
                                    entityItem.func_70106_y();
                                } else {
                                    entityItem.func_92058_a(stack);
                                }
                                EntityItem arrows = new EntityItem(this.field_70170_p, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, new ItemStack(ItemRegistry.SHOCK_ARROW, converted));
                                this.field_70170_p.func_72838_d((Entity)arrows);
                                continue;
                            }
                            if (item != ItemRegistry.CHIROBARB_ERUPTER) continue;
                            entityItem.func_92058_a(new ItemStack(ItemRegistry.CHIROBARB_SHOCK_ERUPTER, stack.func_190916_E()));
                            continue;
                        }
                        if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (EntityLightningBolt)this)) continue;
                        entity.func_70077_a((EntityLightningBolt)this);
                    }
                }
            }
        } else if (this.delay == 0 && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            this.spawnArcs();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnArcs() {
        float dst;
        Entity view = Minecraft.func_71410_x().func_175606_aa();
        if (view != null && (this.delay < 30 || this.field_70173_aa % (this.delay / 20 + 1) == 0) && (dst = view.func_70032_d((Entity)this)) < 100.0f) {
            float ox = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 4.0f;
            float oy = this.isFloatingTarget ? (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 4.0f : this.field_70170_p.field_73012_v.nextFloat() * 2.0f;
            float oz = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 4.0f;
            ParticleLightningArc particle = (ParticleLightningArc)BLParticles.LIGHTNING_ARC.create(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withColor(0.5f, 0.4f, 1.0f, 0.9f)).withData(new Vec3d(this.field_70165_t + (double)ox, this.field_70163_u + (double)oy, this.field_70161_v + (double)oz)));
            if (dst > 30.0f) {
                particle.setBaseSize(0.1f);
                particle.setSubdivs(2, 1);
                particle.setSplits(2);
            }
            BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.BEAM, particle);
            if (dst < 16.0f) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.ZAP, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
            }
        }
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeBoolean(this.isFloatingTarget);
        buf.writeInt(this.delay);
        buf.writeInt(this.startPos.func_177958_n());
        buf.writeInt(this.startPos.func_177956_o());
        buf.writeInt(this.startPos.func_177952_p());
    }

    public void readSpawnData(ByteBuf buf) {
        this.isFloatingTarget = buf.readBoolean();
        this.delay = buf.readInt();
        this.startPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }
}

