/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ParticleSwirl
extends Particle {
    protected float progress = 0.0f;
    protected float startRotation;
    protected float endRadius;
    protected double dragX;
    protected double dragY;
    protected double dragZ;
    protected double offsetX;
    protected double offsetY;
    protected double offsetZ;
    protected double targetX;
    protected double targetY;
    protected double targetZ;
    protected double targetMotionX;
    protected double targetMotionY;
    protected double targetMotionZ;
    private boolean firstUpdate = true;
    private static final float VELOCITY_OFFSET_MULTIPLIER = 4.0f;

    public ParticleSwirl(World world, double x, double y, double z, int maxAge, float scale, float progress) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.progress = progress;
        this.startRotation = (float)((double)this.field_187136_p.nextFloat() * Math.PI * 2.0);
        this.endRadius = 0.35f + this.field_187136_p.nextFloat() * 0.35f;
        this.field_70547_e = maxAge;
        this.field_70544_f = scale;
    }

    public void setOffset(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    public void setTarget(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        if (this.firstUpdate) {
            this.updatePosition();
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
        }
    }

    public void setTargetMotion(double x, double y, double z) {
        this.targetMotionX = x;
        this.targetMotionY = y;
        this.targetMotionZ = z;
        if (this.firstUpdate) {
            double tmx = this.targetMotionX;
            double tmy = this.targetMotionY;
            double my = tmy * 4.0;
            double tmz = this.targetMotionZ;
            this.dragX = MathHelper.func_151237_a((double)(tmx * 4.0), (double)-1.0, (double)1.0);
            this.dragY = MathHelper.func_151237_a((double)my, (double)-0.3, (double)1.0);
            this.dragZ = MathHelper.func_151237_a((double)(tmz * 4.0), (double)-1.0, (double)1.0);
        }
    }

    public void func_180434_a(BufferBuilder worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (this.field_70546_d > 2) {
            super.func_180434_a(worldRendererIn, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
        }
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        if (this.progress > 1.0f) {
            this.func_187112_i();
        }
        this.progress += 0.01f;
        this.updateDrag();
        this.updatePosition();
        this.firstUpdate = false;
    }

    protected void updateDrag() {
        double tmx = this.targetMotionX;
        double tmy = this.targetMotionY;
        double my = tmy * 4.0;
        double tmz = this.targetMotionZ;
        float dragIncrement = 0.1f;
        if (this.dragX > tmx * 4.0) {
            this.dragX -= (double)dragIncrement;
        } else if (this.dragX < tmx * 4.0) {
            this.dragX += (double)dragIncrement;
        }
        if (Math.abs(this.dragX - tmx * 4.0) <= (double)dragIncrement) {
            this.dragX = tmx * 4.0;
        }
        if (this.dragY > my) {
            this.dragY -= (double)dragIncrement;
        } else if (this.dragY < my) {
            this.dragY += (double)dragIncrement;
        }
        if (Math.abs(this.dragY - my) <= (double)dragIncrement) {
            this.dragY = my;
        }
        if (this.dragZ > tmz * 4.0) {
            this.dragZ -= (double)dragIncrement;
        } else if (this.dragZ < tmz * 4.0) {
            this.dragZ += (double)dragIncrement;
        }
        if (Math.abs(this.dragZ - tmz * 4.0) <= (double)dragIncrement) {
            this.dragZ = tmz * 4.0;
        }
        this.dragX = MathHelper.func_151237_a((double)this.dragX, (double)-1.0, (double)1.0);
        this.dragY = MathHelper.func_151237_a((double)this.dragY, (double)-0.3, (double)1.0);
        this.dragZ = MathHelper.func_151237_a((double)this.dragZ, (double)-1.0, (double)1.0);
    }

    protected void updatePosition() {
        double sx = this.targetX + this.offsetX - this.dragX;
        double sy = this.targetY + this.offsetY - this.dragY;
        double sz = this.targetZ + this.offsetZ - this.dragZ;
        double dx = this.targetX - sx;
        double dy = this.targetY - sy;
        double dz = this.targetZ - sz;
        this.field_187126_f = sx + dx * (1.0 - Math.pow(1.0f - this.progress, 3.0)) + Math.sin((double)this.startRotation + (double)(this.progress * 4.0f) * Math.PI * 2.0) * (double)this.progress * (double)this.endRadius;
        this.field_187127_g = sy + dy * (double)this.progress;
        this.field_187128_h = sz + dz * (1.0 - Math.pow(1.0f - this.progress, 3.0)) + Math.cos((double)this.startRotation + (double)(this.progress * 4.0f) * Math.PI * 2.0) * (double)this.progress * (double)this.endRadius;
    }
}

