/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.entity.layer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.armor.ModelRendererItemAttachment;

@SideOnly(value=Side.CLIENT)
public class LayerAttachedItems<T extends EntityLivingBase>
implements LayerRenderer<T> {
    protected final ModelBase model;
    private final Multimap<ModelRenderer, ModelRendererItemAttachment<T>> attachments = ArrayListMultimap.create();

    public LayerAttachedItems(ModelBase model) {
        this.model = model;
    }

    public LayerAttachedItems<T> attach(ModelRenderer root, ModelRenderer part, Function<T, ItemStack> stack, EnumHandSide side, float scale, Consumer<ModelRenderer> transformSetter) {
        ModelRendererItemAttachment<T> attachment = new ModelRendererItemAttachment<T>(this.model, stack, side, scale);
        transformSetter.accept(attachment);
        this.attachments.put((Object)root, attachment);
        part.func_78792_a(attachment);
        return this;
    }

    public LayerAttachedItems<T> attach(ModelRenderer root, ModelRenderer part, Function<T, ItemStack> stack, EnumHandSide side, float scale) {
        return this.attach(root, part, stack, side, scale, renderer -> {});
    }

    public void func_177141_a(EntityLivingBase entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        EntityLivingBase entity = entityIn;
        this.model.func_78086_a(entity, limbSwing, limbSwingAmount, partialTicks);
        this.model.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, (Entity)entity);
        for (ModelRenderer basePart : this.attachments.keys()) {
            Collection itemAttachments = this.attachments.get((Object)basePart);
            for (ModelRendererItemAttachment attachment : itemAttachments) {
                attachment.setEntity(entity);
                attachment.field_78807_k = false;
            }
            this.render(basePart, itemAttachments, scale);
            for (ModelRendererItemAttachment attachment : itemAttachments) {
                attachment.field_78807_k = true;
            }
        }
    }

    private void render(ModelRenderer part, Collection<? extends ModelRenderer> attachments, float scale) {
        if (attachments.contains(part)) {
            part.func_78785_a(scale);
        } else if (part.field_78805_m != null) {
            GlStateManager.func_179094_E();
            part.func_78794_c(scale);
            for (ModelRenderer child : part.field_78805_m) {
                this.render(child, attachments, scale);
            }
            GlStateManager.func_179121_F();
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

