/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.block;

import java.nio.FloatBuffer;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.BufferUtils;
import thebetweenlands.client.render.block.VertexBatchRenderer;

public class RingOfDispersionWorldRenderer {
    private final FloatBuffer fogColor = BufferUtils.createFloatBuffer((int)4);
    private int rangeXZ;
    private int rangeY;
    private World world;
    private BlockPos pos = BlockPos.field_177992_a;
    private BlockPos renderedPos = BlockPos.field_177992_a;
    private boolean currentlyUsingVbos = false;
    private final Map<BlockRenderLayer, BufferBuilder> bufferBuilders = new EnumMap<BlockRenderLayer, BufferBuilder>(BlockRenderLayer.class);
    private final Map<BlockRenderLayer, VertexBatchRenderer> batchRenderers = new EnumMap<BlockRenderLayer, VertexBatchRenderer>(BlockRenderLayer.class);

    public RingOfDispersionWorldRenderer(int rangeXZ, int rangeY) {
        this.rangeXZ = rangeXZ;
        this.rangeY = rangeY;
        this.fogColor.put(new float[4]);
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    protected BufferBuilder getBufferBuilder(BlockRenderLayer layer) {
        BufferBuilder builder = this.bufferBuilders.get(layer);
        if (builder == null) {
            builder = new BufferBuilder(4000);
            this.bufferBuilders.put(layer, builder);
        }
        return builder;
    }

    protected VertexBatchRenderer getBatchRenderer(BlockRenderLayer layer) {
        VertexBatchRenderer renderer = this.batchRenderers.get(layer);
        if (renderer == null) {
            renderer = new VertexBatchRenderer(DefaultVertexFormats.field_176600_a, OpenGlHelper.func_176075_f());
            this.batchRenderers.put(layer, renderer);
        }
        return renderer;
    }

    public void render() {
        if (this.world == null) {
            return;
        }
        if (this.currentlyUsingVbos != OpenGlHelper.func_176075_f()) {
            this.deleteBuffers();
        }
        this.currentlyUsingVbos = OpenGlHelper.func_176075_f();
        if (!this.pos.equals((Object)this.renderedPos)) {
            this.renderedPos = this.pos;
            this.rebuildVertexBuffer();
        }
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)this.renderedPos.func_177958_n() - mc.func_175598_ae().field_78725_b), (double)((double)this.renderedPos.func_177956_o() - mc.func_175598_ae().field_78726_c), (double)((double)this.renderedPos.func_177952_p() - mc.func_175598_ae().field_78723_d));
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179127_m();
        this.fogColor.rewind();
        GlStateManager.func_187402_b((int)2918, (FloatBuffer)this.fogColor);
        GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
        GlStateManager.func_179102_b((float)(this.rangeXZ - 1));
        GlStateManager.func_179153_c((float)this.rangeXZ);
        this.renderBuffers(mc);
        GlStateManager.func_179106_n();
        GlStateManager.func_179121_F();
    }

    protected void renderBuffers(Minecraft mc) {
        GlStateManager.func_179092_a((int)516, (float)0.5f);
        GlStateManager.func_179118_c();
        this.renderLayerBuffer(mc, BlockRenderLayer.SOLID);
        GlStateManager.func_179141_d();
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, mc.field_71474_y.field_151442_I > 0);
        this.renderLayerBuffer(mc, BlockRenderLayer.CUTOUT_MIPPED);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        this.renderLayerBuffer(mc, BlockRenderLayer.CUTOUT);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        this.renderLayerBuffer(mc, BlockRenderLayer.TRANSLUCENT);
        GlStateManager.func_179118_c();
        this.renderLayerBuffer(mc, BlockRenderLayer.TRANSLUCENT);
        GlStateManager.func_179141_d();
    }

    protected void renderLayerBuffer(Minecraft mc, BlockRenderLayer layer) {
        VertexBatchRenderer batchRenderer = this.getBatchRenderer(layer);
        GlStateManager.func_179103_j((int)7425);
        RenderHelper.func_74518_a();
        mc.field_71460_t.func_175072_h();
        batchRenderer.render();
        mc.field_71460_t.func_175072_h();
    }

    protected void rebuildVertexBuffer() {
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            this.getBufferBuilder(layer).func_181668_a(7, DefaultVertexFormats.field_176600_a);
        }
        for (int xo = -this.rangeXZ; xo <= this.rangeXZ; ++xo) {
            for (int yo = -this.rangeY; yo <= 0; ++yo) {
                for (int zo = -this.rangeXZ; zo <= this.rangeXZ; ++zo) {
                    BlockPos pos = new BlockPos((Vec3i)this.renderedPos.func_177982_a(xo, yo, zo));
                    IBlockState state = this.world.func_180495_p(pos);
                    EnumBlockRenderType renderType = state.func_185901_i();
                    if (state.func_177230_c().isAir(state, (IBlockAccess)this.world, pos) || renderType != EnumBlockRenderType.MODEL && renderType != EnumBlockRenderType.LIQUID) continue;
                    state = state.func_185899_b((IBlockAccess)this.world, pos);
                    IBakedModel blockModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
                    state = state.func_177230_c().getExtendedState(state, (IBlockAccess)this.world, pos);
                    if (blockModel == null) continue;
                    for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                        if (!state.func_177230_c().canRenderInLayer(state, layer)) continue;
                        int prevPass = MinecraftForgeClient.getRenderPass();
                        BlockRenderLayer prevLayer = MinecraftForgeClient.getRenderLayer();
                        ForgeHooksClient.setRenderPass((int)0);
                        ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                        BufferBuilder bufferBuilder = this.getBufferBuilder(layer);
                        bufferBuilder.func_178969_c((double)(-this.renderedPos.func_177958_n()), (double)(-this.renderedPos.func_177956_o()), (double)(-this.renderedPos.func_177952_p()));
                        switch (renderType) {
                            case MODEL: {
                                blockRenderer.func_175019_b().func_178267_a((IBlockAccess)this.world, blockModel, state, pos, bufferBuilder, layer == BlockRenderLayer.TRANSLUCENT);
                                break;
                            }
                            case LIQUID: {
                                blockRenderer.func_175018_a(state, pos, (IBlockAccess)this.world, bufferBuilder);
                            }
                        }
                        bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
                        ForgeHooksClient.setRenderPass((int)prevPass);
                        ForgeHooksClient.setRenderLayer((BlockRenderLayer)prevLayer);
                    }
                }
            }
        }
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            BufferBuilder bufferBuilder = this.getBufferBuilder(layer);
            if (layer == BlockRenderLayer.TRANSLUCENT) {
                bufferBuilder.func_181674_a(0.0f, 2.0f, 0.0f);
            }
            VertexBatchRenderer batchRenderer = this.getBatchRenderer(layer);
            batchRenderer.compile(bufferBuilder);
        }
    }

    public void deleteBuffers() {
        this.bufferBuilders.clear();
        for (VertexBatchRenderer batchRenderer : this.batchRenderers.values()) {
            batchRenderer.deleteBuffers();
        }
        this.batchRenderers.clear();
    }
}

