/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.spell;

import electroblob.tfspellpack.registry.TFSPItems;
import electroblob.tfspellpack.util.TFSPUtils;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.client.particle.TFParticleType;
import twilightforest.potions.TFPotions;

public class FrostBreath
extends SpellRay {
    public FrostBreath() {
        super("tfspellpack", "frost_breath", true, EnumAction.NONE);
        this.aimAssist(0.3f);
        this.soundValues(0.5f, 0.5f, 0.0f);
        this.npcSelector(TFSPUtils.IN_TF_DIMENSION);
        this.addProperties(new String[]{"damage", "effect_duration", "effect_strength"});
    }

    public boolean applicableForItem(Item item) {
        return item == TFSPItems.twilight_spell_book || item == TFSPItems.twilight_scroll;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (WizardryUtilities.isLiving((Entity)target)) {
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if (MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FROST, (Entity)target)) {
                if (!world.field_72995_K && ticksInUse == 1 && caster instanceof EntityPlayer) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                }
            } else if (ticksInUse % ((EntityLivingBase)target).field_70771_an == 1) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(TFPotions.frosty, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), this.getProperty("effect_strength").intValue()));
                float damage = this.getProperty("damage").floatValue() * modifiers.get("potency");
                if (target instanceof EntityBlaze || target instanceof EntityMagmaCube) {
                    damage *= 2.0f;
                }
                WizardryUtilities.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.FROST), (float)damage);
            }
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        if (ticksInUse % 5 == 0) {
            super.playSound(world, x, y, z, ticksInUse, duration, modifiers, sounds);
        }
    }

    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, EntityLivingBase caster, double distance) {
        double dist = 0.5;
        double px = origin.field_72450_a + direction.field_72450_a * 0.5;
        double py = origin.field_72448_b + direction.field_72448_b * 0.5;
        double pz = origin.field_72449_c + direction.field_72449_c * 0.5;
        for (int i = 0; i < 10; ++i) {
            double dx = direction.field_72450_a;
            double dy = direction.field_72448_b;
            double dz = direction.field_72449_c;
            double spread = 5.0 + world.field_73012_v.nextDouble() * 2.5;
            double velocity = 3.0 + world.field_73012_v.nextDouble() * 0.15;
            dx += world.field_73012_v.nextGaussian() * 0.0075 * spread;
            dy += world.field_73012_v.nextGaussian() * 0.0075 * spread;
            dz += world.field_73012_v.nextGaussian() * 0.0075 * spread;
            TwilightForestMod.proxy.spawnParticle(TFParticleType.SNOW, px, py, pz, dx *= velocity, dy *= velocity, dz *= velocity);
        }
    }
}

