/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.spell;

import electroblob.tfspellpack.registry.TFSPItems;
import electroblob.tfspellpack.util.TFSPParticles;
import electroblob.tfspellpack.util.TFSPUtils;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WizardryUtilities;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import twilightforest.block.BlockTFCastleMagic;
import twilightforest.block.TFBlocks;
import twilightforest.network.PacketAnnihilateBlock;
import twilightforest.network.TFPacketHandler;

public class Annihilation
extends SpellRay {
    public Annihilation() {
        super("tfspellpack", "annihilation", false, EnumAction.NONE);
        this.addProperties(new String[]{"damage"});
        this.npcSelector(TFSPUtils.IN_TF_DIMENSION);
    }

    public boolean applicableForItem(Item item) {
        return item == TFSPItems.twilight_spell_book || item == TFSPItems.twilight_scroll;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        target.func_70097_a(caster == null ? DamageSource.field_76376_m : MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.MAGIC), this.getProperty("damage").floatValue() * modifiers.get("potency"));
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (!WizardryUtilities.canDamageBlocks((EntityLivingBase)caster, (World)world)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos) && Annihilation.canAnnihilate(world, pos, state, caster)) {
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187541_bC, WizardrySounds.SPELLS, 0.125f, world.field_73012_v.nextFloat() * 0.25f + 0.75f, false);
            if (!world.field_72995_K) {
                world.func_175698_g(pos);
                Annihilation.sendAnnihilateBlockPacket(world, pos);
            }
        }
        return true;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticleRay(World world, Vec3d origin, Vec3d direction, EntityLivingBase caster, double distance) {
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(distance));
        ParticleBuilder.create((ResourceLocation)TFSPParticles.DARK_BEAM).clr(0.2f, 0.0f, 0.5f).fade(0.0f, 0.0f, 0.2f).time(4).pos(origin).target(endpoint).spawn(world);
    }

    private static boolean canAnnihilate(World world, BlockPos pos, IBlockState state, EntityLivingBase caster) {
        Block block = state.func_177230_c();
        if (block == TFBlocks.deadrock || block == TFBlocks.castle_brick || block == TFBlocks.castle_rune_brick && state.func_177229_b(BlockTFCastleMagic.COLOR) != EnumDyeColor.PURPLE || block == TFBlocks.force_field || block == TFBlocks.thorns) {
            return true;
        }
        return block.func_149638_a((Entity)caster) < 8.0f && state.func_185887_b(world, pos) >= 0.0f;
    }

    private static void sendAnnihilateBlockPacket(World world, BlockPos pos) {
        PacketAnnihilateBlock message = new PacketAnnihilateBlock(pos);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0);
        TFPacketHandler.CHANNEL.sendToAllAround((IMessage)message, targetPoint);
    }
}

