/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.entity.living;

import electroblob.tfspellpack.Settings;
import electroblob.tfspellpack.TFSpellPack;
import electroblob.tfspellpack.registry.TFSPItems;
import electroblob.tfspellpack.registry.TFSPSounds;
import electroblob.tfspellpack.registry.TFSPSpells;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellProperties;
import electroblob.wizardry.util.WizardryUtilities;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import twilightforest.TFConfig;
import twilightforest.block.BlockTFTrapDoor;
import twilightforest.entity.EntityTFSkeletonDruid;

@Mod.EventBusSubscriber
public class EntityDruidMage
extends EntityEvilWizard {
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("tfspellpack", "entities/druid_mage");
    private static final float TWILIGHT_SPELL_CHANCE = 0.75f;
    private static final int BASEMENT_SEARCH_RADIUS = 10;
    private static final Method getEntityId = ObfuscationReflectionHelper.findMethod(MobSpawnerBaseLogic.class, (String)"func_190895_g", ResourceLocation.class, (Class[])new Class[0]);

    public EntityDruidMage(World world) {
        super(world);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
    }

    public Element getElement() {
        return Element.MAGIC;
    }

    public void setElement(Element element) {
    }

    protected SoundEvent func_184639_G() {
        return TFSPSounds.ENTITY_DRUID_MAGE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TFSPSounds.ENTITY_DRUID_MAGE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TFSPSounds.ENTITY_DRUID_MAGE_DEATH;
    }

    protected float func_70647_i() {
        return 0.7f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected void func_70628_a(boolean hitByPlayer, int lootingLevel) {
    }

    protected ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        this.getSpells().add(TFSPSpells.druid_hex);
        EntityDruidMage.populateSpells((EntityLiving)this, this.getSpells(), 3, this.field_70146_Z);
        return data;
    }

    public void writeSpawnData(ByteBuf data) {
    }

    public void readSpawnData(ByteBuf data) {
    }

    private static void populateSpells(EntityLiving wizard, List<Spell> spells, int n, Random random) {
        List twilightSpells = Spell.getSpells(s -> s.canBeCastBy(wizard, true));
        twilightSpells.removeIf(s -> !s.applicableForItem(TFSPItems.twilight_spell_book));
        List regularSpells = Spell.getSpells(s -> s.canBeCastBy(wizard, false));
        regularSpells.removeIf(s -> !s.applicableForItem(WizardryItems.spell_book));
        for (int i = 0; i < n; ++i) {
            List pool = random.nextFloat() < 0.75f ? twilightSpells : regularSpells;
            Element element = Element.values()[random.nextInt(Element.values().length)];
            int randomiser = random.nextInt(20);
            Tier tier = randomiser < 10 ? Tier.NOVICE : (randomiser < 16 ? Tier.APPRENTICE : (randomiser < 19 ? Tier.ADVANCED : Tier.MASTER));
            List list = Spell.getSpells((Predicate)new Spell.TierElementFilter(tier, element, new SpellProperties.Context[]{SpellProperties.Context.NPCS}));
            list.retainAll(pool);
            list.removeAll(spells);
            if (list.isEmpty()) {
                list = pool;
                list.removeAll(spells);
            }
            if (list.isEmpty()) continue;
            spells.add((Spell)list.get(random.nextInt(list.size())));
        }
    }

    @SubscribeEvent
    public static void onDecorateBiomePostEvent(DecorateBiomeEvent.Post event) {
        if (Settings.druidMageSpawnChance == 0.0) {
            return;
        }
        if (event.getWorld().field_73011_w.getDimension() == TFConfig.dimension.dimensionID) {
            ArrayList tileEntities = new ArrayList(event.getWorld().field_147482_g);
            for (TileEntity tileEntity : tileEntities) {
                BlockPos pos = tileEntity.func_174877_v();
                if (!(tileEntity instanceof TileEntityMobSpawner) || !new ChunkPos(pos).equals((Object)event.getChunkPos())) continue;
                try {
                    if (!getEntityId.invoke((Object)((TileEntityMobSpawner)tileEntity).func_145881_a(), new Object[0]).equals(EntityList.func_191306_a(EntityTFSkeletonDruid.class))) continue;
                    EntityDruidMage.lookForBasementAndSpawnDruidMage(event.getWorld(), pos);
                    return;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    TFSpellPack.logger.error("Error reflectively getting spawner entity: ", (Throwable)e);
                }
            }
        }
    }

    private static void lookForBasementAndSpawnDruidMage(World world, BlockPos spawnerPos) {
        for (int dx = -10; dx <= 10; ++dx) {
            for (int dy = -10; dy <= 10; ++dy) {
                for (int dz = -10; dz <= 10; ++dz) {
                    Integer floor;
                    BlockPos pos = spawnerPos.func_177982_a(dx, dy, dz);
                    if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockTrapDoor) && !(world.func_180495_p(pos).func_177230_c() instanceof BlockTFTrapDoor)) continue;
                    if ((double)world.field_73012_v.nextFloat() < Settings.druidMageSpawnChance && (floor = WizardryUtilities.getNearestSurface((World)world, (BlockPos)pos, (EnumFacing)EnumFacing.DOWN, (int)16, (boolean)false, (WizardryUtilities.SurfaceCriteria)WizardryUtilities.SurfaceCriteria.COLLIDABLE.flip())) != null) {
                        EntityDruidMage druidMage = new EntityDruidMage(world);
                        druidMage.func_70107_b((double)pos.func_177958_n() + 0.5, floor.intValue(), (double)pos.func_177952_p() + 0.5);
                        druidMage.hasStructure = true;
                        druidMage.func_180482_a(world.func_175649_E(pos), null);
                        world.func_72838_d((Entity)druidMage);
                    }
                    return;
                }
            }
        }
    }
}

