/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.spawners;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.worldgen.spawners.SpawnPotential;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;

class SpawnPotentialParser {
    SpawnPotentialParser() {
    }

    public static List<SpawnPotential> parse(JsonElement data) throws Exception {
        ArrayList spawnPotentials = Lists.newArrayList();
        for (JsonElement spawnPotentialJson : data.getAsJsonArray()) {
            SpawnPotential spawnPotential = SpawnPotentialParser.parse(spawnPotentialJson.getAsJsonObject());
            spawnPotentials.add(spawnPotential);
        }
        return spawnPotentials;
    }

    private static SpawnPotential parse(JsonObject entry) throws Exception {
        int weight;
        int n = weight = entry.has("weight") ? entry.get("weight").getAsInt() : 1;
        if (!entry.has("name")) {
            throw new Exception("Spawn potential missing name");
        }
        String name = entry.get("name").getAsString();
        boolean equip = entry.has("equip") && entry.get("equip").getAsBoolean();
        NBTTagCompound nbt = entry.has("nbt") ? JsonToNBT.func_180713_a((String)entry.get("nbt").getAsString()) : new NBTTagCompound();
        return new SpawnPotential(name, equip, weight, nbt);
    }
}

