/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import net.minecraft.block.BlockLever;
import net.minecraft.util.EnumFacing;

public enum Cardinal {
    NORTH(EnumFacing.SOUTH, BlockLever.EnumOrientation.SOUTH),
    EAST(EnumFacing.WEST, BlockLever.EnumOrientation.WEST),
    SOUTH(EnumFacing.NORTH, BlockLever.EnumOrientation.NORTH),
    WEST(EnumFacing.EAST, BlockLever.EnumOrientation.EAST),
    UP(EnumFacing.UP, BlockLever.EnumOrientation.UP_X),
    DOWN(EnumFacing.DOWN, BlockLever.EnumOrientation.DOWN_X);

    private final EnumFacing facing;
    private final BlockLever.EnumOrientation orientation;
    public static Cardinal[] directions;

    private Cardinal(EnumFacing facing, BlockLever.EnumOrientation orientation) {
        this.facing = facing;
        this.orientation = orientation;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public BlockLever.EnumOrientation getOrientation() {
        return this.orientation;
    }

    public Cardinal reverse() {
        switch (this) {
            case NORTH: {
                return SOUTH;
            }
            case EAST: {
                return WEST;
            }
            case WEST: {
                return EAST;
            }
            case SOUTH: {
                return NORTH;
            }
            case UP: {
                return DOWN;
            }
        }
        return UP;
    }

    public Cardinal antiClockwise() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case EAST: {
                return NORTH;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
        }
        return this;
    }

    public Cardinal clockwise() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case EAST: {
                return SOUTH;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
        }
        return this;
    }

    public Cardinal[] orthogonal() {
        switch (this) {
            case NORTH: {
                return new Cardinal[]{WEST, EAST};
            }
            case SOUTH: {
                return new Cardinal[]{EAST, WEST};
            }
            case EAST: {
                return new Cardinal[]{NORTH, SOUTH};
            }
            case WEST: {
                return new Cardinal[]{SOUTH, NORTH};
            }
        }
        return new Cardinal[]{this, this};
    }

    static {
        directions = new Cardinal[]{NORTH, EAST, SOUTH, WEST};
    }
}

