/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.util;

import java.util.Random;
import net.minecraft.item.EnumDyeColor;

public enum DyeColor {
    WHITE,
    ORANGE,
    MAGENTA,
    LIGHT_BLUE,
    YELLOW,
    LIME,
    PINK,
    GRAY,
    LIGHT_GRAY,
    CYAN,
    PURPLE,
    BLUE,
    BROWN,
    GREEN,
    RED,
    BLACK;


    public static EnumDyeColor get(DyeColor color) {
        try {
            return EnumDyeColor.valueOf((String)color.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return EnumDyeColor.WHITE;
        }
    }

    public static DyeColor get(Random rand) {
        return DyeColor.values()[rand.nextInt(DyeColor.values().length)];
    }

    public static int RGBToColor(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static int HSLToColor(float h, float s, float l) {
        float r;
        float g;
        float b;
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
            float p = 2.0f * l - q;
            r = DyeColor.hueToRgb(p, q, h + 0.33333334f);
            g = DyeColor.hueToRgb(p, q, h);
            b = DyeColor.hueToRgb(p, q, h - 0.33333334f);
        }
        return DyeColor.RGBToColor((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f));
    }

    public static float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }
}

