/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.treasure.TreasureManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;

public class LootTableRule {
    List<Integer> levels = Lists.newArrayList();
    private ResourceLocation table;
    private List<Treasure> types = Lists.newArrayList();

    public LootTableRule() {
    }

    public LootTableRule(List<Integer> levels, ResourceLocation table, List<Treasure> types) {
        this.levels = levels;
        this.table = table;
        this.types = types;
    }

    public LootTableRule(JsonObject json) throws Exception {
        this(LootTableRule.parseLevels(json), LootTableRule.parseTable(json), LootTableRule.parseType(json));
    }

    public static LootTableRule newLootTableRule(int level, String table, Treasure treasure) {
        LootTableRule lootTableRule = new LootTableRule();
        lootTableRule.addLevel(level);
        lootTableRule.setTable(table);
        lootTableRule.addTreasureType(treasure);
        return lootTableRule;
    }

    public void addLevel(int level) {
        this.levels.add(level);
    }

    public void setTable(String table) {
        this.table = new ResourceLocation(table);
    }

    public void addTreasureType(Treasure type) {
        this.types.add(type);
    }

    private static List<Integer> parseLevels(JsonObject json) {
        if (!json.has("level")) {
            return Lists.newArrayList();
        }
        JsonElement level = json.get("level");
        ArrayList<Integer> levels = new ArrayList<Integer>();
        if (!level.isJsonArray()) {
            levels.add(level.getAsInt());
        } else {
            for (JsonElement i : level.getAsJsonArray()) {
                levels.add(i.getAsInt());
            }
        }
        return levels;
    }

    private static ResourceLocation parseTable(JsonObject json) throws Exception {
        if (!json.has("table")) {
            throw new Exception("Loot table requires a table field");
        }
        return new ResourceLocation(json.get("table").getAsString());
    }

    private static List<Treasure> parseType(JsonObject json) {
        ArrayList type = Lists.newArrayList();
        if (!json.has("type")) {
            return type;
        }
        JsonElement typeElement = json.get("type");
        if (!typeElement.isJsonArray()) {
            type.add(Treasure.valueOf(typeElement.getAsString()));
        } else {
            for (JsonElement treasure : typeElement.getAsJsonArray()) {
                type.add(Treasure.valueOf(treasure.getAsString()));
            }
        }
        return type;
    }

    public void process(TreasureManager treasure) {
        this.getMatching(treasure).stream().filter(chest -> chest.getType() != Treasure.EMPTY).forEach(chest -> chest.setLootTable(this.table));
    }

    private List<ITreasureChest> getMatching(TreasureManager treasure) {
        return treasure.getChests().stream().filter(chest -> this.levels.isEmpty() || this.levels.contains(chest.getLevel())).filter(chest -> this.types.isEmpty() || this.types.contains((Object)chest.getType())).collect(Collectors.toList());
    }
}

