/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.treasure.TreasureManager;
import greymerk.roguelike.util.IWeighted;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class LootRule {
    int level;
    int amount;
    private Treasure type;
    private IWeighted<ItemStack> item;
    private boolean toEach;

    public LootRule(Treasure type, IWeighted<ItemStack> item, int level, boolean toEach, int amount) {
        this.type = type;
        this.item = item;
        this.level = level;
        this.toEach = toEach;
        this.amount = amount;
    }

    public void process(Random rand, TreasureManager treasure) {
        if (this.toEach && this.type != null) {
            treasure.addItemToAll(rand, this.type, this.level, this.item, this.amount);
        }
        if (this.toEach && this.type == null) {
            treasure.addItemToAll(rand, this.level, this.item, this.amount);
        }
        if (!this.toEach && this.type != null) {
            treasure.addItem(rand, this.type, this.level, this.item, this.amount);
        }
        if (!this.toEach && this.type == null) {
            treasure.addItem(rand, this.level, this.item, this.amount);
        }
    }

    public String toString() {
        String type = this.type != null ? this.type.toString() : "NONE";
        int level = this.level;
        int amount = this.amount;
        return "type: " + type + " level: " + level + " amount: " + amount;
    }
}

