/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure;

import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.util.IWeighted;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;

public class TreasureManager {
    List<ITreasureChest> chests = new ArrayList<ITreasureChest>();

    public void add(ITreasureChest toAdd) {
        this.chests.add(toAdd);
    }

    public void addItemToAll(Random rand, Treasure type, int level, IWeighted<ItemStack> item, int amount) {
        this.addItemToAll(rand, this.getChests(type, level), item, amount);
    }

    public void addItemToAll(Random rand, int level, IWeighted<ItemStack> item, int amount) {
        this.addItemToAll(rand, this.getChests(level), item, amount);
    }

    public void addItemToAll(Random rand, Treasure type, IWeighted<ItemStack> item, int amount) {
        this.addItemToAll(rand, this.getChests(type), item, amount);
    }

    private void addItemToAll(Random rand, List<ITreasureChest> chests, IWeighted<ItemStack> item, int amount) {
        chests.forEach(chest -> IntStream.range(0, amount).mapToObj(i -> (ItemStack)item.get(rand)).forEach(chest::setRandomEmptySlot));
    }

    public void addItem(Random rand, int level, IWeighted<ItemStack> item, int amount) {
        this.addItem(rand, this.getChests(level), item, amount);
    }

    public void addItem(Random rand, Treasure type, IWeighted<ItemStack> item, int amount) {
        this.addItem(rand, this.getChests(type), item, amount);
    }

    public void addItem(Random rand, Treasure type, int level, IWeighted<ItemStack> item, int amount) {
        this.addItem(rand, this.getChests(type, level), item, amount);
    }

    private void addItem(Random rand, List<ITreasureChest> chests, IWeighted<ItemStack> item, int amount) {
        if (chests.isEmpty()) {
            return;
        }
        IntStream.range(0, amount).mapToObj(i -> (ITreasureChest)chests.get(rand.nextInt(chests.size()))).forEach(chest -> chest.setRandomEmptySlot((ItemStack)item.get(rand)));
    }

    public List<ITreasureChest> getChests(Treasure type, int level) {
        return this.chests.stream().filter(chest -> chest.isType(type)).filter(chest -> chest.isOnLevel(level)).collect(Collectors.toList());
    }

    public List<ITreasureChest> getChests(Treasure type) {
        return this.chests.stream().filter(chest -> chest.isType(type)).collect(Collectors.toList());
    }

    public List<ITreasureChest> getChests(int level) {
        return this.chests.stream().filter(ITreasureChest::isNotEmpty).filter(chest -> chest.isOnLevel(level)).collect(Collectors.toList());
    }

    public List<ITreasureChest> getChests() {
        return this.chests.stream().filter(ITreasureChest::isNotEmpty).collect(Collectors.toList());
    }
}

