/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.towers;

import greymerk.roguelike.dungeon.towers.ITower;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.blocks.Leaves;
import greymerk.roguelike.worldgen.blocks.Log;
import greymerk.roguelike.worldgen.blocks.Vine;
import greymerk.roguelike.worldgen.blocks.Wood;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.ArrayList;
import java.util.Random;

public class JungleTower
implements ITower {
    @Override
    public void generate(IWorldEditor editor, Random rand, ITheme theme, Coord dungeon) {
        Coord end;
        Coord start;
        Coord c;
        Coord cursor;
        Coord origin = Tower.getBaseCoord(editor, dungeon);
        origin.translate(Cardinal.UP);
        IBlockFactory pillar = theme.getPrimary().getPillar();
        IBlockFactory walls = theme.getPrimary().getWall();
        IStair stair = theme.getPrimary().getStair();
        MetaBlock grass = BlockType.get(BlockType.GRASS);
        for (Cardinal dir : Cardinal.directions) {
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 3);
            cursor.translate(dir, 7);
            this.pillar(editor, rand, theme, cursor);
            for (Cardinal o : dir.orthogonal()) {
                c = new Coord(cursor);
                c.translate(o, 3);
                this.pillar(editor, rand, theme, c);
                c.translate(dir);
                c.translate(Cardinal.UP);
                walls.set(editor, rand, c);
                c.translate(Cardinal.UP);
                walls.set(editor, rand, c);
                c.translate(Cardinal.UP);
                stair.setOrientation(dir, false).set(editor, c);
                c.translate(dir.reverse());
                walls.set(editor, rand, c);
            }
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 4);
            cursor.translate(dir, 8);
            walls.set(editor, rand, cursor);
            cursor.translate(Cardinal.UP);
            walls.set(editor, rand, cursor);
            cursor.translate(Cardinal.UP);
            stair.setOrientation(dir, false).set(editor, cursor);
            cursor.translate(dir.reverse());
            walls.set(editor, rand, cursor);
            start = new Coord(origin);
            start.translate(dir, 2);
            start.translate(dir.antiClockwise(), 2);
            end = new Coord(start);
            end.translate(Cardinal.UP, 3);
            pillar.fill(editor, rand, new RectSolid(start, end));
            cursor = new Coord(end);
            for (Cardinal d : new Cardinal[]{dir.reverse(), dir.clockwise()}) {
                c = new Coord(cursor);
                c.translate(d);
                stair.setOrientation(d, true).set(editor, c);
            }
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 6);
            cursor.translate(dir, 6);
            cursor.translate(dir.antiClockwise(), 6);
            editor.fillDown(rand, new Coord(cursor), pillar);
            for (Cardinal d : new Cardinal[]{dir, dir.antiClockwise()}) {
                start = new Coord(cursor);
                start.translate(d);
                stair.setOrientation(d, false).set(editor, start);
                start.translate(Cardinal.DOWN);
                end = new Coord(start);
                end.translate(Cardinal.DOWN, 2);
                walls.fill(editor, rand, new RectSolid(start, end));
                end.translate(Cardinal.DOWN);
                stair.setOrientation(d, true).set(editor, end);
            }
        }
        for (Cardinal dir : Cardinal.directions) {
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 4);
            cursor.translate(dir, 7);
            start = new Coord(cursor);
            end = new Coord(cursor);
            start.translate(dir.antiClockwise(), 5);
            end.translate(dir.clockwise(), 5);
            walls.fill(editor, rand, new RectSolid(start, end));
            start.translate(Cardinal.UP);
            end.translate(Cardinal.UP);
            grass.fill(editor, rand, new RectSolid(start, end));
            start.translate(dir.reverse());
            end.translate(dir.reverse());
            walls.fill(editor, rand, new RectSolid(start, end));
            start.translate(dir.reverse());
            end.translate(dir.reverse());
            stair.setOrientation(dir.reverse(), true).fill(editor, rand, new RectSolid(start, end));
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 4);
            cursor.translate(dir, 6);
            this.pillar(editor, rand, theme, cursor);
            for (Cardinal o : dir.orthogonal()) {
                c = new Coord(cursor);
                c.translate(o, 3);
                this.pillar(editor, rand, theme, c);
            }
            start = new Coord(origin);
            start.translate(Cardinal.UP, 5);
            start.translate(dir, 2);
            end = new Coord(start);
            end.translate(dir, 3);
            walls.fill(editor, rand, new RectSolid(start, end));
            end.translate(dir.antiClockwise(), 3);
            start = new Coord(end);
            start.translate(dir.reverse(), 10);
            walls.fill(editor, rand, new RectSolid(start, end));
            start = new Coord(origin);
            start.translate(Cardinal.UP, 6);
            start.translate(dir, 3);
            start.translate(dir.antiClockwise(), 2);
            end = new Coord(start);
            end.translate(dir.clockwise(), 8);
            end.translate(dir, 3);
            walls.fill(editor, rand, new RectSolid(start, end));
            start = new Coord(origin);
            start.translate(Cardinal.UP, 4);
            start.translate(dir, 2);
            end = new Coord(start);
            start.translate(dir.antiClockwise(), 2);
            end.translate(dir.clockwise());
            end.translate(Cardinal.UP, 2);
            walls.fill(editor, rand, new RectSolid(start, end));
            start = new Coord(origin);
            start.translate(Cardinal.UP, 4);
            start.translate(dir, 3);
            end = new Coord(start);
            start.translate(dir.antiClockwise(), 3);
            end.translate(dir.clockwise(), 2);
            stair.setOrientation(dir, true).fill(editor, rand, new RectSolid(start, end));
        }
        for (Cardinal dir : Cardinal.directions) {
            for (Cardinal o : dir.orthogonal()) {
                start = new Coord(origin);
                start.translate(Cardinal.UP, 6);
                start.translate(dir, 5);
                start.translate(o);
                end = new Coord(start);
                end.translate(o);
                end.translate(dir);
                grass.fill(editor, rand, new RectSolid(start, end));
                start.translate(o, 3);
                end.translate(o, 3);
                grass.fill(editor, rand, new RectSolid(start, end));
            }
        }
        for (Cardinal dir : Cardinal.directions) {
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 9);
            cursor.translate(dir, 5);
            for (Cardinal o : dir.orthogonal()) {
                c = new Coord(cursor);
                c.translate(o, 2);
                this.pillar(editor, rand, theme, c);
                c.translate(dir);
                c.translate(Cardinal.UP);
                walls.set(editor, rand, c);
                c.translate(Cardinal.UP);
                stair.setOrientation(dir, false).set(editor, c);
                c.translate(dir.reverse());
                walls.set(editor, rand, c);
                c.translate(Cardinal.UP);
                stair.setOrientation(dir, false).set(editor, c);
            }
            cursor.translate(dir.antiClockwise(), 5);
            this.pillar(editor, rand, theme, cursor);
            for (Cardinal d : new Cardinal[]{dir.antiClockwise(), dir}) {
                c = new Coord(cursor);
                c.translate(d);
                c.translate(Cardinal.UP);
                walls.set(editor, rand, c);
                c.translate(Cardinal.UP);
                stair.setOrientation(d, false).set(editor, c);
            }
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 10);
            cursor.translate(dir, 2);
            cursor.translate(dir.antiClockwise(), 2);
            start = new Coord(cursor);
            end = new Coord(start);
            end.translate(Cardinal.DOWN, 3);
            pillar.fill(editor, rand, new RectSolid(start, end));
            for (Cardinal d : new Cardinal[]{dir.clockwise(), dir.reverse()}) {
                c = new Coord(cursor);
                c.translate(d);
                stair.setOrientation(d, true).set(editor, c);
            }
            cursor.translate(Cardinal.DOWN);
            for (Cardinal d : new Cardinal[]{dir.antiClockwise(), dir}) {
                c = new Coord(cursor);
                c.translate(d);
                stair.setOrientation(d, true).set(editor, c);
                c.translate(Cardinal.UP);
                walls.set(editor, rand, c);
                c.translate(d);
                walls.set(editor, rand, c);
            }
        }
        for (Cardinal dir : Cardinal.directions) {
            start = new Coord(origin);
            start.translate(Cardinal.UP, 10);
            start.translate(dir, 5);
            end = new Coord(start);
            start.translate(dir.antiClockwise(), 5);
            end.translate(dir.clockwise(), 4);
            walls.fill(editor, rand, new RectSolid(start, end));
            start = new Coord(origin);
            start.translate(Cardinal.UP, 11);
            start.translate(dir, 2);
            end = new Coord(start);
            start.translate(dir.antiClockwise());
            end.translate(dir.clockwise(), 4);
            end.translate(dir, 2);
            walls.fill(editor, rand, new RectSolid(start, end));
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 11);
            cursor.translate(dir, 5);
            start = new Coord(cursor);
            end = new Coord(start);
            start.translate(dir.antiClockwise(), 4);
            end.translate(dir.clockwise(), 4);
            grass.fill(editor, rand, new RectSolid(start, end));
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 12);
            cursor.translate(dir, 3);
            start = new Coord(cursor);
            end = new Coord(start);
            end.translate(dir);
            start.translate(dir.antiClockwise());
            end.translate(dir.clockwise(), 4);
            grass.fill(editor, rand, new RectSolid(start, end));
        }
        for (Cardinal dir : Cardinal.directions) {
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 12);
            cursor.translate(dir, 2);
            start = new Coord(cursor);
            end = new Coord(cursor);
            start.translate(dir.antiClockwise(), 4);
            end.translate(dir.clockwise(), 4);
            walls.fill(editor, rand, new RectSolid(start, end));
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 11);
            cursor.translate(dir, 5);
            cursor.translate(dir.antiClockwise(), 5);
            walls.set(editor, rand, cursor);
        }
        for (Cardinal dir : Cardinal.directions) {
            cursor = new Coord(origin);
            cursor.translate(dir, 2);
            cursor.translate(dir.antiClockwise(), 2);
            cursor.translate(Cardinal.UP, 15);
            this.pillar(editor, rand, theme, cursor);
            for (Cardinal d : new Cardinal[]{dir, dir.antiClockwise()}) {
                c = new Coord(cursor);
                c.translate(d);
                c.translate(Cardinal.UP);
                walls.set(editor, rand, c);
                c.translate(Cardinal.UP);
                stair.setOrientation(d, false).set(editor, c);
            }
            start = new Coord(origin);
            start.translate(Cardinal.UP, 16);
            start.translate(dir, 2);
            end = new Coord(start);
            start.translate(dir.antiClockwise());
            end.translate(dir.clockwise(), 2);
            walls.fill(editor, rand, new RectSolid(start, end));
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 17);
            cursor.translate(dir, 2);
            start = new Coord(cursor);
            end = new Coord(cursor);
            start.translate(dir.antiClockwise());
            end.translate(dir.clockwise());
            grass.fill(editor, rand, new RectSolid(start, end));
            cursor.translate(dir.antiClockwise(), 2);
            walls.set(editor, rand, cursor);
            start = new Coord(origin);
            start.translate(Cardinal.UP, 17);
            end = new Coord(start);
            start.translate(dir);
            start.translate(dir.antiClockwise());
            end.translate(dir.reverse());
            end.translate(dir.clockwise());
            walls.fill(editor, rand, new RectSolid(start, end));
            start.translate(Cardinal.UP);
            end.translate(Cardinal.UP);
            grass.fill(editor, rand, new RectSolid(start, end));
        }
        start = new Coord(origin);
        start.translate(Cardinal.NORTH, 2);
        start.translate(Cardinal.EAST, 2);
        end = new Coord(origin.getX(), dungeon.getY() + 10, origin.getZ());
        end.translate(Cardinal.SOUTH, 2);
        end.translate(Cardinal.WEST, 2);
        walls.fill(editor, rand, new RectSolid(start, end), false, true);
        cursor = new Coord(origin);
        cursor.translate(Cardinal.UP, 12);
        start = new Coord(cursor.getX(), dungeon.getY(), cursor.getZ());
        end = new Coord(cursor);
        for (Coord c2 : new RectSolid(start, end)) {
            editor.spiralStairStep(rand, c2, stair, pillar);
        }
        this.decorate(editor, rand, theme, origin);
    }

    private void decorate(IWorldEditor editor, Random rand, ITheme theme, Coord origin) {
        ArrayList<Coord> spots = new ArrayList<Coord>();
        for (Cardinal dir : Cardinal.directions) {
            Coord c;
            Coord cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 6);
            cursor.translate(dir, 7);
            for (Cardinal o : dir.orthogonal()) {
                c = new Coord(cursor);
                c.translate(o);
                spots.add(new Coord(c));
                c.translate(o);
                spots.add(new Coord(c));
                c.translate(o, 2);
                spots.add(new Coord(c));
                c.translate(o);
                spots.add(new Coord(c));
            }
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 12);
            cursor.translate(dir, 5);
            spots.add(new Coord(cursor));
            for (Cardinal o : dir.orthogonal()) {
                c = new Coord(cursor);
                c.translate(o);
                spots.add(new Coord(c));
                c.translate(o, 2);
                spots.add(new Coord(c));
                c.translate(o);
                spots.add(new Coord(c));
            }
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 13);
            cursor.translate(dir, 4);
            spots.add(new Coord(cursor));
            for (Cardinal o : dir.orthogonal()) {
                c = new Coord(cursor);
                c.translate(o);
                spots.add(new Coord(c));
                c.translate(o, 2);
                spots.add(new Coord(c));
                c.translate(o);
                spots.add(new Coord(c));
            }
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 18);
            cursor.translate(dir, 2);
            spots.add(new Coord(cursor));
            for (Cardinal o : dir.orthogonal()) {
                c = new Coord(cursor);
                c.translate(o);
                spots.add(new Coord(c));
            }
            cursor = new Coord(origin);
            cursor.translate(Cardinal.UP, 19);
            Coord start = new Coord(cursor);
            Coord end = new Coord(cursor);
            start.translate(dir);
            end.translate(dir.reverse());
            start.translate(dir.antiClockwise());
            end.translate(dir.clockwise());
            spots.addAll(new RectSolid(start, end).get());
        }
        for (Coord c : spots) {
            if (!rand.nextBoolean()) continue;
            this.tree(editor, rand, theme, c);
        }
        Coord start = new Coord(origin);
        Coord end = new Coord(origin);
        end.translate(Cardinal.UP, 20);
        start.translate(Cardinal.NORTH, 8);
        start.translate(Cardinal.EAST, 8);
        end.translate(Cardinal.SOUTH, 8);
        end.translate(Cardinal.WEST, 8);
        Vine.fill(editor, start, end);
    }

    private void tree(IWorldEditor editor, Random rand, ITheme theme, Coord origin) {
        Coord c;
        MetaBlock leaves = Leaves.get(Wood.JUNGLE, false);
        Coord cursor = new Coord(origin);
        Log.getLog(Wood.JUNGLE).set(editor, cursor);
        for (Cardinal dir : Cardinal.directions) {
            c = new Coord(cursor);
            c.translate(dir);
            this.leafSpill(editor, rand, theme, c, rand.nextInt(6));
        }
        if (rand.nextBoolean()) {
            cursor.translate(Cardinal.UP);
            Log.getLog(Wood.JUNGLE).set(editor, cursor);
            for (Cardinal dir : Cardinal.directions) {
                c = new Coord(cursor);
                c.translate(dir);
                leaves.set(editor, rand, c, true, false);
            }
        }
        if (rand.nextInt(3) == 0) {
            cursor.translate(Cardinal.UP);
            Log.getLog(Wood.JUNGLE).set(editor, cursor);
            for (Cardinal dir : Cardinal.directions) {
                c = new Coord(cursor);
                c.translate(dir);
                leaves.set(editor, rand, c, true, false);
            }
        }
        cursor.translate(Cardinal.UP);
        leaves.set(editor, cursor);
    }

    public void leafSpill(IWorldEditor editor, Random rand, ITheme theme, Coord origin, int count) {
        if (count < 0) {
            return;
        }
        MetaBlock leaves = Leaves.get(Wood.JUNGLE, false);
        leaves.set(editor, origin);
        Coord cursor = new Coord(origin);
        cursor.translate(Cardinal.DOWN);
        if (!editor.getBlock(cursor).func_185904_a().func_76218_k()) {
            leaves.set(editor, origin);
            if (rand.nextBoolean()) {
                this.leafSpill(editor, rand, theme, cursor, count - 1);
            }
            return;
        }
        for (Cardinal dir : Cardinal.directions) {
            cursor = new Coord(origin);
            cursor.translate(dir);
            if (editor.getBlock(cursor).func_185904_a().func_76218_k()) continue;
            leaves.set(editor, origin);
            cursor.translate(Cardinal.DOWN);
            if (editor.getBlock(cursor).func_185904_a().func_76218_k()) continue;
            this.leafSpill(editor, rand, theme, cursor, count - 1);
        }
    }

    private void pillar(IWorldEditor editor, Random rand, ITheme theme, Coord origin) {
        IBlockFactory pillar = theme.getPrimary().getPillar();
        IStair stair = theme.getPrimary().getStair();
        editor.fillDown(rand, new Coord(origin), pillar);
        for (Cardinal dir : Cardinal.directions) {
            Coord cursor = new Coord(origin);
            cursor.translate(dir);
            stair.setOrientation(dir, true).set(editor, cursor);
        }
    }
}

