/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.towers;

import greymerk.roguelike.dungeon.towers.ITower;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.BlockJumble;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.blocks.Vine;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class HoleTower
implements ITower {
    @Override
    public void generate(IWorldEditor editor, Random rand, ITheme theme, Coord origin) {
        MetaBlock air = BlockType.get(BlockType.AIR);
        IBlockFactory blocks = theme.getPrimary().getWall();
        Coord floor = Tower.getBaseCoord(editor, origin);
        Coord start = new Coord(floor);
        start.translate(Cardinal.NORTH);
        start.translate(Cardinal.EAST);
        start.translate(Cardinal.UP, 3);
        Coord end = new Coord(origin);
        end.translate(Cardinal.SOUTH);
        end.translate(Cardinal.WEST);
        RectSolid.fill(editor, rand, start, end, air);
        start.translate(Cardinal.NORTH, 2);
        start.translate(Cardinal.EAST, 2);
        end.translate(Cardinal.SOUTH, 2);
        end.translate(Cardinal.WEST, 2);
        end.translate(Cardinal.UP);
        BlockJumble rubble = new BlockJumble();
        rubble.addBlock(blocks);
        rubble.addBlock(BlockType.get(BlockType.AIR));
        rubble.addBlock(BlockType.get(BlockType.DIRT));
        rubble.addBlock(BlockType.get(BlockType.DIRT_COARSE));
        rubble.addBlock(BlockType.get(BlockType.STONE_SMOOTH));
        RectSolid.fill(editor, rand, start, end, rubble, false, true);
        Vine.fill(editor, start, end);
    }
}

