/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.builtin;

import com.google.common.collect.Lists;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.base.RoomsSetting;
import greymerk.roguelike.dungeon.base.SecretsSetting;
import greymerk.roguelike.dungeon.segment.Segment;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.settings.base.SettingsBase;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.filter.Filter;
import net.minecraftforge.common.BiomeDictionary;

public class SettingsForestTheme
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "forest");

    public SettingsForestTheme() {
        super(ID);
        this.setExclusive(true);
        this.getInherit().add(SettingsBase.ID);
        this.getSpawnCriteria().setBiomeTypes(Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST}));
        this.setTowerSettings(new TowerSettings(Tower.ROGUE, Theme.TOWER));
        for (int i = 0; i < 5; ++i) {
            LevelSettings level = new LevelSettings();
            switch (i) {
                case 0: {
                    RoomsSetting rooms = new RoomsSetting();
                    rooms.add(RoomType.CORNER.newRandomRoomSetting(8));
                    rooms.add(RoomType.BRICK.newRandomRoomSetting(3));
                    rooms.add(RoomType.CAKE.newSingleRoomSetting());
                    rooms.add(RoomType.DARKHALL.newSingleRoomSetting());
                    rooms.add(RoomType.LIBRARY.newSingleRoomSetting());
                    level.setRooms(rooms);
                    SecretsSetting secrets = new SecretsSetting();
                    secrets.add(RoomType.SMITH.newSingleRoomSetting());
                    secrets.add(RoomType.BEDROOM.newSingleRoomSetting());
                    secrets.add(RoomType.BEDROOM.newSingleRoomSetting());
                    level.setSecrets(secrets);
                    level.setTheme(Theme.SPRUCE.getThemeBase());
                    SegmentGenerator segments = new SegmentGenerator(Segment.ARCH);
                    segments.add(Segment.DOOR, 8);
                    segments.add(Segment.LAMP, 2);
                    segments.add(Segment.WHEAT, 3);
                    segments.add(Segment.FLOWERS, 2);
                    segments.add(Segment.INSET, 1);
                    segments.add(Segment.PLANT, 2);
                    segments.add(Segment.SHELF, 1);
                    segments.add(Segment.CHEST, 1);
                    level.setSegments(segments);
                    break;
                }
                case 1: {
                    RoomsSetting rooms = new RoomsSetting();
                    rooms.add(RoomType.MUSIC.newSingleRoomSetting());
                    rooms.add(RoomType.PIT.newSingleRoomSetting());
                    rooms.add(RoomType.LAB.newSingleRoomSetting());
                    rooms.add(RoomType.SLIME.newSingleRoomSetting());
                    rooms.add(RoomType.SLIME.newSingleRoomSetting());
                    rooms.add(RoomType.CORNER.newRandomRoomSetting(10));
                    rooms.add(RoomType.BRICK.newRandomRoomSetting(3));
                    level.setRooms(rooms);
                    level.setTheme(Theme.DARKHALL.getThemeBase());
                    SegmentGenerator segments = new SegmentGenerator(Segment.ARCH);
                    segments.add(Segment.DOOR, 10);
                    segments.add(Segment.FLOWERS, 2);
                    segments.add(Segment.INSET, 2);
                    segments.add(Segment.PLANT, 2);
                    segments.add(Segment.SHELF, 2);
                    segments.add(Segment.CHEST, 1);
                    level.setSegments(segments);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            this.getLevels().put(i, level);
        }
        this.getLevels().get(3).addFilter(Filter.VINE);
    }
}

