/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.base;

import com.google.common.collect.Lists;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.treasure.loot.Book;
import greymerk.roguelike.treasure.loot.Equipment;
import greymerk.roguelike.treasure.loot.ILoot;
import greymerk.roguelike.treasure.loot.Loot;
import greymerk.roguelike.treasure.loot.LootRuleManager;
import greymerk.roguelike.treasure.loot.LootTableRule;
import greymerk.roguelike.treasure.loot.Quality;
import greymerk.roguelike.treasure.loot.provider.ItemEnchBook;
import greymerk.roguelike.treasure.loot.provider.ItemSpecialty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;

public class SettingsLootRules
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "loot");

    public SettingsLootRules() {
        super(ID);
        this.setExclusive(false);
        this.setLootRules(new LootRuleManager());
        ILoot loot = Loot.getLoot();
        this.addStarterLoot(loot);
        this.addRewardLoot();
        for (int i = 0; i < 5; ++i) {
            this.getLootRules().add(Treasure.ARMOUR, loot.get(Loot.POTION, i), i, true, 1);
            this.getLootRules().add(Treasure.ARMOUR, loot.get(Loot.ARMOUR, i), i, true, 1);
            this.getLootRules().add(Treasure.ARMOUR, loot.get(Loot.FOOD, i), i, true, 1);
            this.getLootRules().add(Treasure.WEAPONS, loot.get(Loot.POTION, i), i, true, 1);
            this.getLootRules().add(Treasure.WEAPONS, loot.get(Loot.WEAPON, i), i, true, 1);
            this.getLootRules().add(Treasure.WEAPONS, loot.get(Loot.FOOD, i), i, true, 1);
            this.getLootRules().add(Treasure.WEAPONS, loot.get(Loot.FOOD, i), i, true, 1);
            this.getLootRules().add(Treasure.BLOCKS, loot.get(Loot.BLOCK, i), i, true, 6);
            this.getLootRules().add(Treasure.ENCHANTING, loot.get(Loot.ENCHANTBONUS, i), i, true, 2);
            this.getLootRules().add(Treasure.ENCHANTING, loot.get(Loot.ENCHANTBOOK, i), i, true, 1);
            this.getLootRules().add(Treasure.FOOD, loot.get(Loot.FOOD, i), i, true, 8);
            this.getLootRules().add(Treasure.ORE, loot.get(Loot.ORE, i), i, true, 5);
            this.getLootRules().add(Treasure.POTIONS, loot.get(Loot.POTION, i), i, true, 6);
            this.getLootRules().add(Treasure.BREWING, loot.get(Loot.BREWING, i), i, true, 8);
            this.getLootRules().add(Treasure.TOOLS, loot.get(Loot.ORE, i), i, true, 1);
            this.getLootRules().add(Treasure.TOOLS, loot.get(Loot.TOOL, i), i, true, 1);
            this.getLootRules().add(Treasure.TOOLS, loot.get(Loot.BLOCK, i), i, true, 1);
            this.getLootRules().add(Treasure.SUPPLIES, loot.get(Loot.SUPPLY, i), i, true, 6);
            this.getLootRules().add(Treasure.SMITH, loot.get(Loot.ORE, i), i, true, 6);
            this.getLootRules().add(Treasure.SMITH, loot.get(Loot.SMITHY, i), i, true, 1);
            this.getLootRules().add(Treasure.MUSIC, loot.get(Loot.MUSIC, i), i, true, 1);
            this.getLootRules().add(Treasure.REWARD, loot.get(Loot.REWARD, i), i, true, 1);
            this.getLootRules().add(null, loot.get(Loot.JUNK, i), i, true, 6);
            this.getLootRules().add(null, new ItemSpecialty(0, i, Quality.get(i)), i, false, 3);
            this.getLootRules().add(null, new ItemEnchBook(0, i), i, false, i * 2 + 5);
        }
    }

    private void addRewardLoot() {
        this.useLootTableForLevel(LootTableList.field_186422_d, 0);
        this.useLootTableForLevel(LootTableList.field_186429_k, 1);
        this.useLootTableForLevel(LootTableList.field_186430_l, 2);
        this.useLootTableForLevel(LootTableList.field_186425_g, 3);
        this.useLootTableForLevel(LootTableList.field_186421_c, 4);
    }

    private void useLootTableForLevel(ResourceLocation chestsSimpleDungeon, int level) {
        this.getLootTables().add(new LootTableRule(Lists.newArrayList((Object[])new Integer[]{level}), new ResourceLocation(chestsSimpleDungeon.func_110623_a()), Lists.newArrayList((Object[])new Treasure[]{Treasure.REWARD})));
    }

    private void addStarterLoot(ILoot loot) {
        this.getLootRules().add(Treasure.STARTER, Book.get(Book.CREDITS));
        this.getLootRules().add(Treasure.STARTER, loot.get(Loot.WEAPON, 0), 0, true, 2);
        this.getLootRules().add(Treasure.STARTER, loot.get(Loot.FOOD, 0), 0, true, 2);
        this.getLootRules().add(Treasure.STARTER, loot.get(Loot.TOOL, 0), 0, true, 2);
        this.getLootRules().add(Treasure.STARTER, loot.get(Loot.SUPPLY, 0), 0, true, 2);
        this.getLootRules().add(Treasure.STARTER, new ItemSpecialty(0, 0, Equipment.LEGS, Quality.WOOD), 0, true, 2);
    }
}

