/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings;

import greymerk.roguelike.config.RogueConfig;
import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SettingsBlank;
import greymerk.roguelike.dungeon.settings.SettingsContainer;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;

public class SettingsResolver {
    private final SettingsContainer settingsContainer;

    public SettingsResolver(SettingsContainer settingsContainer) {
        this.settingsContainer = settingsContainer;
    }

    public DungeonSettings getAnyCustomDungeonSettings(IWorldEditor editor, Coord coord) {
        block3: {
            Optional<DungeonSettings> custom;
            Optional<DungeonSettings> builtin;
            block2: {
                builtin = this.chooseOneBuiltinSettingAtRandom(editor, coord);
                custom = this.chooseRandomCustomDungeonIfPossible(editor, coord);
                if (builtin.isPresent()) break block2;
                if (!custom.isPresent()) break block3;
            }
            return custom.orElseGet(builtin::get);
        }
        return null;
    }

    public DungeonSettings getByName(String name) {
        try {
            DungeonSettings setting;
            DungeonSettings byName;
            SettingIdentifier id = new SettingIdentifier(name);
            if (this.settingsContainer.contains(id) && (byName = this.processInheritance(setting = new DungeonSettings(this.settingsContainer.get(id)))) != null) {
                return new DungeonSettings(new SettingsBlank(), byName);
            }
            return null;
        }
        catch (Exception e) {
            Minecraft.func_71410_x().field_71439_g.func_71165_d(Arrays.toString(e.getStackTrace()));
            throw new RuntimeException(e);
        }
    }

    public DungeonSettings processInheritance(DungeonSettings dungeonSettings) {
        return dungeonSettings.getInherits().stream().peek(this::throwIfNotFound).map(this.settingsContainer::get).reduce(dungeonSettings, this::inherit);
    }

    private void throwIfNotFound(SettingIdentifier settingIdentifier) {
        if (!this.settingsContainer.contains(settingIdentifier)) {
            throw new RuntimeException("Setting not found: " + settingIdentifier.toString());
        }
    }

    private DungeonSettings inherit(DungeonSettings child, DungeonSettings parent) {
        return new DungeonSettings(this.processInheritance(parent), child);
    }

    private Optional<DungeonSettings> chooseOneBuiltinSettingAtRandom(IWorldEditor editor, Coord coord) {
        if (!RogueConfig.getBoolean(RogueConfig.SPAWNBUILTIN)) {
            return Optional.empty();
        }
        WeightedRandomizer<DungeonSettings> settingsRandomizer = this.newWeightedRandomizer(this.getValidBuiltinSettings(editor, coord));
        if (settingsRandomizer.isEmpty()) {
            return Optional.empty();
        }
        Random random = Dungeon.getRandom(editor, coord);
        DungeonSettings randomSetting = settingsRandomizer.get(random);
        DungeonSettings builtin = this.processInheritance(randomSetting);
        return Optional.ofNullable(builtin);
    }

    private List<DungeonSettings> getValidBuiltinSettings(IWorldEditor editor, Coord coord) {
        return this.filterValid(this.settingsContainer.getBuiltinSettings(), editor, coord);
    }

    private List<DungeonSettings> filterValid(Collection<DungeonSettings> builtinSettings, IWorldEditor editor, Coord coord) {
        return builtinSettings.stream().filter(this.isValid(editor, coord)).filter(DungeonSettings::isExclusive).collect(Collectors.toList());
    }

    private Optional<DungeonSettings> chooseRandomCustomDungeonIfPossible(IWorldEditor editor, Coord coord) {
        List<DungeonSettings> validCustomSettings = this.filterValid(this.settingsContainer.getCustomSettings(), editor, coord);
        WeightedRandomizer<DungeonSettings> settingsRandomizer = this.newWeightedRandomizer(validCustomSettings);
        Random random = Dungeon.getRandom(editor, coord);
        return Optional.ofNullable(settingsRandomizer.get(random)).map(this::processInheritance);
    }

    private WeightedRandomizer<DungeonSettings> newWeightedRandomizer(List<DungeonSettings> dungeonSettings) {
        WeightedRandomizer<DungeonSettings> settingsRandomizer = new WeightedRandomizer<DungeonSettings>();
        dungeonSettings.stream().map(setting -> new WeightedChoice<DungeonSettings>((DungeonSettings)setting, setting.getSpawnCriteria().getWeight())).forEach(settingsRandomizer::add);
        return settingsRandomizer;
    }

    private Predicate<DungeonSettings> isValid(IWorldEditor editor, Coord pos) {
        return setting -> setting.isValid(editor, pos);
    }

    public String toString(String namespace) {
        return this.settingsContainer.getByNamespace(namespace).stream().map(DungeonSettings::getId).map(SettingIdentifier::toString).collect(Collectors.joining(" "));
    }

    public String toString() {
        return this.settingsContainer.toString();
    }
}

