/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.blocks.TallPlant;
import greymerk.roguelike.worldgen.blocks.Trapdoor;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class SegmentPlant
extends SegmentBase {
    @Override
    protected void genWall(IWorldEditor editor, Random rand, DungeonLevel level, Cardinal dir, ITheme theme, Coord origin) {
        MetaBlock air = BlockType.get(BlockType.AIR);
        IStair stair = theme.getSecondary().getStair();
        Coord cursor = new Coord(origin);
        Cardinal[] orth = dir.orthogonal();
        cursor.translate(dir, 2);
        Coord start = new Coord(cursor);
        start.translate(orth[0], 1);
        Coord end = new Coord(cursor);
        end.translate(orth[1], 1);
        end.translate(Cardinal.UP, 2);
        RectSolid.fill(editor, rand, start, end, air);
        start.translate(dir, 1);
        end.translate(dir, 1);
        RectSolid.fill(editor, rand, start, end, theme.getSecondary().getWall(), false, true);
        cursor.translate(Cardinal.UP, 2);
        for (Cardinal d : orth) {
            Coord c = new Coord(cursor);
            c.translate(d, 1);
            stair.setOrientation(d.reverse(), true);
            stair.set(editor, c);
        }
        cursor = new Coord(origin);
        cursor.translate(dir, 2);
        this.plant(editor, rand, theme, cursor);
    }

    private void plant(IWorldEditor editor, Random rand, ITheme theme, Coord origin) {
        Coord cursor;
        BlockType.get(BlockType.DIRT_PODZOL).set(editor, origin);
        for (Cardinal dir : Cardinal.directions) {
            cursor = new Coord(origin);
            cursor.translate(dir);
            Trapdoor.get(Trapdoor.OAK, dir.reverse(), true, true).set(editor, rand, cursor, true, false);
        }
        cursor = new Coord(origin);
        cursor.translate(Cardinal.UP);
        TallPlant[] plants = new TallPlant[]{TallPlant.FERN, TallPlant.ROSE, TallPlant.PEONY};
        TallPlant.generate(editor, plants[rand.nextInt(plants.length)], cursor);
    }
}

