/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.segment.part;

import greymerk.roguelike.dungeon.DungeonLevel;
import greymerk.roguelike.dungeon.segment.part.SegmentBase;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.blocks.FlowerPot;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class SegmentFlowers
extends SegmentBase {
    @Override
    protected void genWall(IWorldEditor editor, Random rand, DungeonLevel level, Cardinal dir, ITheme theme, Coord origin) {
        MetaBlock air = BlockType.get(BlockType.AIR);
        IStair stair = theme.getSecondary().getStair();
        Coord cursor = new Coord(origin);
        Cardinal[] orth = dir.orthogonal();
        cursor.translate(dir, 2);
        Coord start = new Coord(cursor);
        start.translate(orth[0], 1);
        Coord end = new Coord(cursor);
        end.translate(orth[1], 1);
        RectSolid.fill(editor, rand, start, end, theme.getSecondary().getWall(), false, true);
        start.translate(dir, 1);
        end.translate(dir, 1);
        end.translate(Cardinal.UP, 2);
        RectSolid.fill(editor, rand, start, end, theme.getSecondary().getWall(), false, true);
        start.translate(dir.reverse(), 1);
        start.translate(Cardinal.UP, 1);
        end.translate(dir.reverse(), 1);
        RectSolid.fill(editor, rand, start, end, air, false, true);
        cursor.translate(Cardinal.UP, 2);
        for (Cardinal d : orth) {
            Coord c = new Coord(cursor);
            c.translate(d, 1);
            stair.setOrientation(d.reverse(), true);
            stair.set(editor, c);
        }
        start = new Coord(origin);
        start.translate(dir, 2);
        start.translate(Cardinal.UP);
        end = new Coord(start);
        start.translate(orth[0]);
        end.translate(orth[1]);
        for (Coord c : new RectSolid(start, end)) {
            if (rand.nextInt(3) != 0 || !editor.getBlock(c).func_185904_a().func_76220_a()) continue;
            FlowerPot.generate(editor, rand, c);
        }
    }
}

