/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms.prototype;

import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.theme.ITheme;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import greymerk.roguelike.worldgen.spawners.MobType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class DungeonEniko
extends DungeonBase {
    public DungeonEniko(RoomSetting roomSetting) {
        super(roomSetting);
    }

    private static void pillar(IWorldEditor editor, Random rand, ITheme theme, Coord origin) {
        IStair stair = theme.getPrimary().getStair();
        IBlockFactory pillar = theme.getPrimary().getPillar();
        Coord start = new Coord(origin);
        Coord end = new Coord(start);
        end.translate(Cardinal.UP, 3);
        RectSolid.fill(editor, rand, start, end, pillar, true, true);
        for (Cardinal dir : Cardinal.directions) {
            Coord cursor = new Coord(end);
            cursor.translate(dir);
            stair.setOrientation(dir, true).set(editor, rand, cursor, true, false);
        }
    }

    @Override
    public DungeonBase generate(IWorldEditor editor, Random rand, LevelSettings settings, Coord origin, Cardinal[] entrances) {
        ITheme theme = settings.getTheme();
        MetaBlock air = BlockType.get(BlockType.AIR);
        IStair stair = theme.getPrimary().getStair();
        IBlockFactory walls = theme.getPrimary().getWall();
        IBlockFactory floor = theme.getPrimary().getFloor();
        ArrayList<Coord> chests = new ArrayList<Coord>();
        Coord start = new Coord(origin);
        Coord end = new Coord(origin);
        start.translate(new Coord(6, -1, 6));
        end.translate(new Coord(-6, 4, -6));
        RectHollow.fill(editor, rand, start, end, walls, false, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.translate(new Coord(6, 4, 6));
        end.translate(new Coord(-6, 5, -6));
        RectSolid.fill(editor, rand, start, end, theme.getSecondary().getWall(), false, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.translate(new Coord(3, 4, 3));
        end.translate(new Coord(-3, 4, -3));
        RectSolid.fill(editor, rand, start, end, air, true, true);
        start = new Coord(origin);
        end = new Coord(origin);
        start.translate(new Coord(-3, -1, -3));
        end.translate(new Coord(3, -1, 3));
        RectSolid.fill(editor, rand, start, end, floor, true, true);
        for (Cardinal dir : Cardinal.directions) {
            Coord cursor = new Coord(origin);
            cursor.translate(dir, 5);
            for (Cardinal o : dir.orthogonal()) {
                Coord c = new Coord(cursor);
                c.translate(o, 2);
                DungeonEniko.pillar(editor, rand, theme, c);
                c = new Coord(cursor);
                c.translate(o, 3);
                stair.setOrientation(dir.reverse(), true).set(editor, c);
                c.translate(o);
                stair.setOrientation(dir.reverse(), true).set(editor, c);
                c.translate(Cardinal.UP);
                chests.add(new Coord(c));
                c.translate(o.reverse());
                chests.add(new Coord(c));
            }
            cursor.translate(dir.antiClockwise(), 5);
            DungeonEniko.pillar(editor, rand, theme, cursor);
            if (!Arrays.asList(entrances).contains((Object)dir)) continue;
            start = new Coord(origin);
            start.translate(Cardinal.DOWN);
            end = new Coord(start);
            start.translate(dir.antiClockwise());
            end.translate(dir.clockwise());
            end.translate(dir, 6);
            RectSolid.fill(editor, rand, start, end, floor, true, true);
        }
        this.generateSpawner(editor, rand, origin, settings.getDifficulty(origin), settings.getSpawners(), MobType.COMMON_MOBS);
        List<Coord> chestLocations = DungeonEniko.chooseRandomLocations(rand, 1, chests);
        Treasure.createChests(editor, rand, settings.getDifficulty(origin), chestLocations, false, Treasure.COMMON_TREASURES);
        return this;
    }

    @Override
    public int getSize() {
        return 7;
    }
}

