/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms;

import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.base.RoomType;
import greymerk.roguelike.dungeon.rooms.Frequency;
import greymerk.roguelike.dungeon.rooms.prototype.BrickRoom;
import greymerk.roguelike.dungeon.rooms.prototype.CornerRoom;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonAshlea;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonAvidya;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonBTeam;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonBedRoom;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonBlaze;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonDarkHall;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonEniko;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonEtho;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonFirework;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonLab;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonLibrary;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonLinker;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonLinkerTop;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonMess;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonOssuary;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonPyramidCorner;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonPyramidSpawner;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonPyramidTomb;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonReward;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonStorage;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonTreetho;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsCreeperDen;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsCrypt;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsEnchant;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsEnder;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsFire;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsMusic;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsNetherBrick;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsPit;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsPrison;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsSlime;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsSmithy;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsSpiderNest;
import greymerk.roguelike.dungeon.rooms.prototype.DungeonsWood;
import greymerk.roguelike.dungeon.rooms.prototype.FortressRoom;
import greymerk.roguelike.dungeon.rooms.prototype.ObsidianRoom;
import java.util.List;

public class RoomSetting {
    private RoomType roomType;
    private String spawnerId;
    private Frequency frequency;
    private int weight;
    private int count;
    private List<Integer> levels;

    public boolean isRandom() {
        return this.frequency.isRandom();
    }

    public boolean isSecret() {
        return this.frequency.isSecret();
    }

    public boolean isSingle() {
        return this.frequency.isSingle();
    }

    public boolean isOnFloorLevel(int floorLevel) {
        return this.getLevels() != null && this.getLevels().contains(floorLevel);
    }

    public DungeonBase instantiate() {
        switch (this.roomType) {
            case ASHLEA: {
                return new DungeonAshlea(this);
            }
            case AVIDYA: {
                return new DungeonAvidya(this);
            }
            case BEDROOM: {
                return new DungeonBedRoom(this);
            }
            case BLAZE: {
                return new DungeonBlaze(this);
            }
            case BTEAM: {
                return new DungeonBTeam(this);
            }
            case CAKE: {
                return new DungeonsWood(this);
            }
            case CORNER: {
                return new CornerRoom(this);
            }
            case CREEPER: {
                return new DungeonsCreeperDen(this);
            }
            case CRYPT: {
                return new DungeonsCrypt(this);
            }
            case DARKHALL: {
                return new DungeonDarkHall(this);
            }
            case ENCHANT: {
                return new DungeonsEnchant(this);
            }
            case ENDER: {
                return new DungeonsEnder(this);
            }
            case ENIKO: {
                return new DungeonEniko(this);
            }
            case ETHO: {
                return new DungeonEtho(this);
            }
            case FIRE: {
                return new DungeonsFire(this);
            }
            case FIREWORK: {
                return new DungeonFirework(this);
            }
            case FORTRESS: {
                return new FortressRoom(this);
            }
            case LAB: {
                return new DungeonLab(this);
            }
            case LIBRARY: {
                return new DungeonLibrary(this);
            }
            case LINKER: {
                return new DungeonLinker(this);
            }
            case LINKERTOP: {
                return new DungeonLinkerTop(this);
            }
            case MESS: {
                return new DungeonMess(this);
            }
            case MUSIC: {
                return new DungeonsMusic(this);
            }
            case NETHER: {
                return new DungeonsNetherBrick(this);
            }
            case OBSIDIAN: {
                return new ObsidianRoom(this);
            }
            case OSSUARY: {
                return new DungeonOssuary(this);
            }
            case PIT: {
                return new DungeonsPit(this);
            }
            case PRISON: {
                return new DungeonsPrison(this);
            }
            case PYRAMIDCORNER: {
                return new DungeonPyramidCorner(this);
            }
            case PYRAMIDSPAWNER: {
                return new DungeonPyramidSpawner(this);
            }
            case PYRAMIDTOMB: {
                return new DungeonPyramidTomb(this);
            }
            case REWARD: {
                return new DungeonReward(this);
            }
            case SLIME: {
                return new DungeonsSlime(this);
            }
            case SMITH: {
                return new DungeonsSmithy(this);
            }
            case SPIDER: {
                return new DungeonsSpiderNest(this);
            }
            case STORAGE: {
                return new DungeonStorage(this);
            }
            case TREETHO: {
                return new DungeonTreetho(this);
            }
        }
        return new BrickRoom(this);
    }

    public String toString() {
        return "RoomSetting(roomType=" + (Object)((Object)this.getRoomType()) + ", spawnerId=" + this.getSpawnerId() + ", frequency=" + (Object)((Object)this.getFrequency()) + ", weight=" + this.getWeight() + ", count=" + this.getCount() + ", levels=" + this.getLevels() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoomSetting)) {
            return false;
        }
        RoomSetting other = (RoomSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RoomType this$roomType = this.getRoomType();
        RoomType other$roomType = other.getRoomType();
        if (this$roomType == null ? other$roomType != null : !((Object)((Object)this$roomType)).equals((Object)other$roomType)) {
            return false;
        }
        String this$spawnerId = this.getSpawnerId();
        String other$spawnerId = other.getSpawnerId();
        if (this$spawnerId == null ? other$spawnerId != null : !this$spawnerId.equals(other$spawnerId)) {
            return false;
        }
        Frequency this$frequency = this.getFrequency();
        Frequency other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !((Object)((Object)this$frequency)).equals((Object)other$frequency)) {
            return false;
        }
        if (this.getWeight() != other.getWeight()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        List<Integer> this$levels = this.getLevels();
        List<Integer> other$levels = other.getLevels();
        return !(this$levels == null ? other$levels != null : !((Object)this$levels).equals(other$levels));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoomSetting;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RoomType $roomType = this.getRoomType();
        result = result * 59 + ($roomType == null ? 43 : ((Object)((Object)$roomType)).hashCode());
        String $spawnerId = this.getSpawnerId();
        result = result * 59 + ($spawnerId == null ? 43 : $spawnerId.hashCode());
        Frequency $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : ((Object)((Object)$frequency)).hashCode());
        result = result * 59 + this.getWeight();
        result = result * 59 + this.getCount();
        List<Integer> $levels = this.getLevels();
        result = result * 59 + ($levels == null ? 43 : ((Object)$levels).hashCode());
        return result;
    }

    public RoomSetting(RoomType roomType, String spawnerId, Frequency frequency, int weight, int count, List<Integer> levels) {
        this.roomType = roomType;
        this.spawnerId = spawnerId;
        this.frequency = frequency;
        this.weight = weight;
        this.count = count;
        this.levels = levels;
    }

    public RoomType getRoomType() {
        return this.roomType;
    }

    public String getSpawnerId() {
        return this.spawnerId;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getCount() {
        return this.count;
    }

    public List<Integer> getLevels() {
        return this.levels;
    }
}

