/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class SecretRoom
extends DungeonBase {
    public SecretRoom(RoomSetting roomSetting) {
        super(roomSetting);
    }

    public boolean isValid(IWorldEditor editor, Cardinal dir, Coord pos) {
        if (this.getRoomSetting().getCount() <= 0) {
            return false;
        }
        DungeonBase prototype = this.createPrototype();
        Coord cursor = new Coord(pos);
        cursor.translate(dir, prototype.getSize() + 5);
        return prototype.validLocation(editor, dir, cursor);
    }

    @Override
    public DungeonBase generate(IWorldEditor editor, Random rand, LevelSettings settings, Coord pos, Cardinal ... dir) {
        DungeonBase prototype = this.createPrototype();
        int size = prototype.getSize();
        Coord start = new Coord(pos);
        Coord end = new Coord(pos);
        Cardinal entrance = dir[0];
        start.translate(entrance.orthogonal()[0]);
        start.translate(Cardinal.DOWN);
        start.translate(entrance, 2);
        end.translate(entrance.orthogonal()[1]);
        end.translate(entrance, size + 5);
        end.translate(Cardinal.UP, 2);
        RectSolid.fill(editor, rand, start, end, settings.getTheme().getPrimary().getWall(), false, true);
        end = new Coord(pos);
        end.translate(entrance, size + 5);
        end.translate(Cardinal.UP);
        RectSolid.fill(editor, rand, pos, end, BlockType.get(BlockType.AIR));
        end.translate(Cardinal.DOWN);
        prototype.generate(editor, rand, settings, end, new Cardinal[]{entrance});
        return prototype;
    }

    @Override
    public int getSize() {
        return this.createPrototype().getSize();
    }

    private DungeonBase createPrototype() {
        return this.getRoomSetting().instantiate();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecretRoom)) {
            return false;
        }
        SecretRoom other = (SecretRoom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SecretRoom;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String toString() {
        return "SecretRoom()";
    }
}

