/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.base;

import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.rooms.RoomSetting;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.shapes.RectHollow;
import greymerk.roguelike.worldgen.spawners.MobType;
import greymerk.roguelike.worldgen.spawners.SpawnerSettings;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public abstract class DungeonBase
implements Comparable<DungeonBase> {
    private RoomSetting roomSetting;

    public DungeonBase() {
    }

    public DungeonBase(RoomSetting roomSetting) {
        this.roomSetting = roomSetting;
    }

    public static List<Coord> chooseRandomLocations(Random random, int limit, List<Coord> spaces) {
        Collections.shuffle(spaces, random);
        return spaces.stream().limit(limit).collect(Collectors.toList());
    }

    public abstract DungeonBase generate(IWorldEditor var1, Random var2, LevelSettings var3, Coord var4, Cardinal[] var5);

    protected void generateSpawner(IWorldEditor editor, Random rand, Coord spawnerLocation, int difficulty, SpawnerSettings levelSettingsSpawners, MobType ... defaultMobs) {
        this.getSpawnerSettings(difficulty, defaultMobs, levelSettingsSpawners).generateSpawner(editor, rand, spawnerLocation, difficulty);
    }

    private SpawnerSettings getSpawnerSettings(int difficulty, MobType[] defaultMobs, SpawnerSettings levelSettingsSpawners) {
        SpawnerSettings dungeonSettingsSpawners;
        DungeonSettings dungeonSettings;
        String spawnerId = this.roomSetting.getSpawnerId();
        if (spawnerId != null && (dungeonSettings = Dungeon.settingsResolver.getByName(spawnerId)) != null && !(dungeonSettingsSpawners = dungeonSettings.getLevelSettings(difficulty).getSpawners()).isEmpty()) {
            return dungeonSettingsSpawners;
        }
        return !levelSettingsSpawners.isEmpty() ? levelSettingsSpawners : MobType.newSpawnerSetting(defaultMobs.length > 0 ? defaultMobs : MobType.COMMON_MOBS);
    }

    public abstract int getSize();

    public boolean validLocation(IWorldEditor editor, Cardinal dir, Coord pos) {
        int size = this.getSize();
        Coord start = new Coord(pos.getX() - size, pos.getY() - 2, pos.getZ() - size);
        Coord end = new Coord(pos.getX() + size, pos.getY() + 5, pos.getZ() + size);
        for (Coord cursor : new RectHollow(start, end)) {
            MetaBlock b = editor.getBlock(cursor);
            if (b.func_185904_a().func_76220_a()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(DungeonBase other) {
        return this.getSize() - other.getSize();
    }

    protected RoomSetting getRoomSetting() {
        return this.roomSetting;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DungeonBase)) {
            return false;
        }
        DungeonBase other = (DungeonBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RoomSetting this$roomSetting = this.getRoomSetting();
        RoomSetting other$roomSetting = other.getRoomSetting();
        return !(this$roomSetting == null ? other$roomSetting != null : !((Object)this$roomSetting).equals(other$roomSetting));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DungeonBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RoomSetting $roomSetting = this.getRoomSetting();
        result = result * 59 + ($roomSetting == null ? 43 : ((Object)$roomSetting).hashCode());
        return result;
    }
}

