/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.commands;

import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.event.LockUnlockableEvent;
import codersafterdark.reskillable.api.event.UnlockUnlockableEvent;
import codersafterdark.reskillable.api.toast.ToastHelper;
import codersafterdark.reskillable.api.unlockable.Unlockable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CmdToggleTrait
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "toggletrait";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "reskillable.command.toggletrait.usage";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        ResourceLocation traitName;
        if (args.length == 0) {
            throw new CommandException("reskillable.command.invalid.missing.playertrait", new Object[0]);
        }
        if (args.length == 1) {
            throw new CommandException("reskillable.command.invalid.missing.trait", new Object[0]);
        }
        EntityPlayerMP player = CmdToggleTrait.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        args[1] = args[1].replaceAll(":", ".");
        String[] parts = args[1].split("\\.");
        ResourceLocation resourceLocation = traitName = parts.length > 1 ? new ResourceLocation(parts[0], args[1].substring(parts[0].length() + 1)) : new ResourceLocation(args[1]);
        if (!ReskillableRegistries.UNLOCKABLES.containsKey(traitName)) {
            throw new CommandException("reskillable.command.invalid.trait", new Object[]{traitName});
        }
        Unlockable trait = (Unlockable)ReskillableRegistries.UNLOCKABLES.getValue(traitName);
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        PlayerSkillInfo skillInfo = data.getSkillInfo(trait.getParentSkill());
        if (skillInfo.isUnlocked(trait)) {
            if (!MinecraftForge.EVENT_BUS.post((Event)new LockUnlockableEvent.Pre((EntityPlayer)player, trait))) {
                skillInfo.lock(trait, (EntityPlayer)player);
                data.saveAndSync();
                MinecraftForge.EVENT_BUS.post((Event)new LockUnlockableEvent.Post((EntityPlayer)player, trait));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("reskillable.command.success.locktrait", new Object[]{traitName, player.func_145748_c_()}));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("reskillable.command.fail.locktrait", new Object[]{traitName, player.func_145748_c_()}));
            }
        } else if (!MinecraftForge.EVENT_BUS.post((Event)new UnlockUnlockableEvent.Pre((EntityPlayer)player, trait))) {
            skillInfo.unlock(trait, (EntityPlayer)player);
            data.saveAndSync();
            MinecraftForge.EVENT_BUS.post((Event)new UnlockUnlockableEvent.Post((EntityPlayer)player, trait));
            ToastHelper.sendUnlockableToast(player, trait);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("reskillable.command.success.unlocktrait", new Object[]{traitName, player.func_145748_c_()}));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("reskillable.command.fail.unlocktrait", new Object[]{traitName, player.func_145748_c_()}));
        }
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 0) {
            return Arrays.asList(server.func_184103_al().func_72369_d());
        }
        if (args.length == 1) {
            String partialName = args[0];
            return Arrays.stream(server.func_184103_al().func_72369_d()).filter(name -> name.startsWith(partialName)).collect(Collectors.toList());
        }
        if (args.length == 2) {
            String partial = args[1].replaceAll(":", ".");
            return ReskillableRegistries.UNLOCKABLES.getValuesCollection().stream().map(Unlockable::getKey).filter(traitName -> traitName.startsWith(partial)).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public int func_82362_a() {
        return 2;
    }
}

