/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.client.gui;

import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.skill.Skill;
import codersafterdark.reskillable.client.base.RenderHelper;
import codersafterdark.reskillable.client.gui.GuiSkillInfo;
import codersafterdark.reskillable.client.gui.handler.InventoryTabHandler;
import codersafterdark.reskillable.client.gui.handler.KeyBindings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiSkills
extends GuiScreen {
    public static final ResourceLocation SKILLS_RES = new ResourceLocation("reskillable", "textures/gui/skills.png");
    private int guiWidth;
    private int guiHeight;
    private Skill hoveredSkill;
    private int offset;
    private int left;
    private int top;
    private int lastY;
    private List<Skill> enabledSkills = new ArrayList<Skill>();
    private List<Skill> skills = new ArrayList<Skill>();

    public GuiSkills() {
        ReskillableRegistries.SKILLS.getValuesCollection().stream().filter(Skill::isEnabled).forEach(this.enabledSkills::add);
    }

    public static void drawSkill(int x, int y, Skill skill) {
        Minecraft mc = Minecraft.func_71410_x();
        int rank = PlayerDataHandler.get((EntityPlayer)mc.field_71439_g).getSkillInfo(skill).getRank();
        if (skill.hasCustomSprites()) {
            ResourceLocation sprite = skill.getSpriteLocation(rank);
            if (sprite != null) {
                mc.field_71446_o.func_110577_a(sprite);
                GuiSkills.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            }
        } else {
            mc.field_71446_o.func_110577_a(skill.getSpriteLocation());
            Pair<Integer, Integer> pair = skill.getSpriteFromRank(rank);
            RenderHelper.drawTexturedModalRect(x, y, 1.0f, (Integer)pair.getKey(), (Integer)pair.getValue(), 16, 16, 0.015625f, 0.015625f);
        }
    }

    public static void drawScrollButtonsTop(int x, int y) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SKILLS_RES);
        RenderHelper.drawTexturedModalRect(x, y, 1.0f, 0, 230, 80, 4);
    }

    public static void drawScrollButtonsBottom(int x, int y) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SKILLS_RES);
        RenderHelper.drawTexturedModalRect(x, y, 1.0f, 0, 235, 80, 4);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        } else if (keyCode == KeyBindings.openGUI.func_151463_i() || keyCode == Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r != null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }

    public void func_73866_w_() {
        this.guiWidth = 176;
        this.guiHeight = 166;
        this.field_146292_n.clear();
        InventoryTabHandler.addTabs(this, this.field_146292_n);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.field_146297_k.field_71446_o.func_110577_a(SKILLS_RES);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.left = this.field_146294_l / 2 - this.guiWidth / 2;
        this.top = this.field_146295_m / 2 - this.guiHeight / 2;
        this.func_73729_b(this.left, this.top, 0, 0, this.guiWidth, this.guiHeight);
        PlayerData data = PlayerDataHandler.get((EntityPlayer)this.field_146297_k.field_71439_g);
        this.hoveredSkill = null;
        this.skills = new ArrayList<Skill>();
        this.enabledSkills.stream().filter(enabledSkill -> !enabledSkill.isHidden()).forEach(this.skills::add);
        int index = 0;
        for (int j = this.offset; j < this.skills.size() && index < 8; ++j) {
            int y;
            Skill skill = this.skills.get(j);
            PlayerSkillInfo skillInfo = data.getSkillInfo(skill);
            int i = index++;
            int w = 79;
            int h = 32;
            int x = this.left + i % 2 * (w + 3) + 8;
            this.lastY = y = this.top + i / 2 * (h + 3) + 18;
            int u = 0;
            int v = this.guiHeight;
            if (mouseX >= x && mouseY >= y && mouseX < x + w && mouseY < y + h) {
                u += w;
                this.hoveredSkill = skill;
            }
            if (skillInfo.isCapped()) {
                v += h;
            }
            this.field_146297_k.field_71446_o.func_110577_a(SKILLS_RES);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(x, y, u, v, w, h);
            GuiSkills.drawSkill(x + 5, y + 9, skill);
            this.field_146297_k.field_71466_p.func_78276_b(skill.getName(), x + 26, y + 6, 0xFFFFFF);
            this.field_146297_k.field_71466_p.func_78276_b(skillInfo.getLevel() + "/" + skill.getCap(), x + 26, y + 17, 0x888888);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiSkills.drawScrollButtonsTop(this.left + 49, this.top + 14);
        GuiSkills.drawScrollButtonsBottom(this.left + 49, this.lastY + 32);
        String skillsStr = new TextComponentTranslation("reskillable.misc.skills", new Object[0]).func_150261_e();
        this.field_146289_q.func_78276_b(skillsStr, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(skillsStr) / 2, this.top + 5, 0x404040);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && this.hoveredSkill != null) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            GuiSkillInfo gui = new GuiSkillInfo(this.hoveredSkill);
            this.field_146297_k.func_147108_a((GuiScreen)gui);
        }
        if (mouseButton == 0 && mouseX >= this.left + 49 && mouseX <= this.left + 128 && mouseY >= this.top + 14) {
            if (mouseY <= this.top + 18) {
                this.scrollUp();
            } else if (mouseY <= this.lastY + 36) {
                this.scrollDown();
            }
        }
    }

    private void scrollUp() {
        this.offset = Math.max(this.offset - 2, 0);
    }

    private void scrollDown() {
        int off = 2;
        if (this.skills.size() % 2 == 1) {
            off = 1;
        }
        this.offset = Math.min(this.offset + 2, Math.max(this.skills.size() - 6 - off, 0));
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        if (Mouse.getEventDWheel() > 0) {
            this.scrollUp();
        } else if (Mouse.getEventDWheel() < 0) {
            this.scrollDown();
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

