/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.base;

import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.api.event.CacheInvalidatedEvent;
import codersafterdark.reskillable.base.ConfigHandler;
import codersafterdark.reskillable.base.LevelLockHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ToolTipHandler {
    private static Map<Class<? extends GuiScreen>, Function<ToolTipInfo, List<String>>> tooltipInjectors = new HashMap<Class<? extends GuiScreen>, Function<ToolTipInfo, List<String>>>();
    private static RequirementHolder lastLock = LevelLockHandler.EMPTY_LOCK;
    private static Class<? extends GuiScreen> currentGui;
    private static List<String> toolTip;
    private static ItemStack lastItem;
    private static boolean enabled;

    public static void resetLast() {
        lastItem = null;
        lastLock = LevelLockHandler.EMPTY_LOCK;
        toolTip = new ArrayList<String>();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onTooltip(ItemTooltipEvent event) {
        if (!enabled || event.isCanceled()) {
            return;
        }
        ItemStack current = event.getItemStack();
        PlayerData data = PlayerDataHandler.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (lastItem != current) {
            lastItem = current;
            lastLock = LevelLockHandler.getSkillLock(current);
            toolTip = new ArrayList<String>();
            lastLock.addRequirementsIgnoreShift(data, toolTip);
        }
        boolean showDetails = !ConfigHandler.hideRequirements || GuiScreen.func_146272_n();
        ArrayList extraToolTips = new ArrayList();
        if (currentGui != null) {
            ToolTipInfo info = new ToolTipInfo(showDetails, data, lastItem);
            for (Map.Entry<Class<? extends GuiScreen>, Function<ToolTipInfo, List<String>>> injectorInfo : tooltipInjectors.entrySet()) {
                if (!injectorInfo.getKey().isAssignableFrom(currentGui)) continue;
                extraToolTips.addAll(injectorInfo.getValue().apply(info));
            }
        }
        if (!toolTip.isEmpty() || !extraToolTips.isEmpty()) {
            List curTooltip = event.getToolTip();
            if (showDetails) {
                curTooltip.add(TextFormatting.DARK_PURPLE + new TextComponentTranslation("reskillable.misc.requirements", new Object[0]).func_150261_e());
                curTooltip.addAll(toolTip);
            } else {
                curTooltip.add(TextFormatting.DARK_PURPLE + new TextComponentTranslation("reskillable.misc.requirements_shift", new Object[0]).func_150261_e());
            }
            curTooltip.addAll(extraToolTips);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onGuiOpen(GuiOpenEvent event) {
        if (enabled && !event.isCanceled()) {
            currentGui = event.getGui() == null ? null : event.getGui().getClass();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void connect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        enabled = true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void disconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        enabled = false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onCacheInvalidated(CacheInvalidatedEvent event) {
        if (event.anyModified()) {
            ToolTipHandler.resetLast();
        }
    }

    public static void addTooltipInjector(Class<? extends GuiScreen> gui, Function<ToolTipInfo, List<String>> creator) {
        tooltipInjectors.put(gui, creator);
    }

    static {
        toolTip = new ArrayList<String>();
    }

    public static class ToolTipInfo {
        private boolean showDetails;
        private PlayerData data;
        private ItemStack item;

        public ToolTipInfo(boolean showDetails, PlayerData data, ItemStack item) {
            this.showDetails = showDetails;
            this.data = data;
            this.item = item;
        }

        public boolean showDetails() {
            return this.showDetails;
        }

        public PlayerData getData() {
            return this.data;
        }

        public ItemStack getItem() {
            return this.item;
        }
    }
}

