/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.reskillable.api.data;

import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.requirement.RequirementCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PlayerDataHandler {
    private static final String DATA_TAG = "SkillableData";
    private static HashMap<Integer, PlayerData> playerData = new HashMap();

    public static PlayerData get(EntityPlayer player) {
        if (player == null) {
            return null;
        }
        int key = PlayerDataHandler.getKey(player);
        if (!playerData.containsKey(key)) {
            playerData.put(key, new PlayerData(player));
        }
        PlayerData data = playerData.get(key);
        if (data.playerWR.get() != player) {
            NBTTagCompound cmp = new NBTTagCompound();
            data.saveToNBT(cmp);
            RequirementCache.removeCache(player.func_110124_au(), player.func_130014_f_().field_72995_K);
            playerData.remove(key);
            data = PlayerDataHandler.get(player);
            data.loadFromNBT(cmp);
        }
        return data;
    }

    public static void cleanup() {
        ArrayList<Integer> removals = new ArrayList<Integer>();
        for (Map.Entry<Integer, PlayerData> item : playerData.entrySet()) {
            PlayerData d = item.getValue();
            if (d == null || d.playerWR.get() != null) continue;
            removals.add(item.getKey());
        }
        removals.forEach(i -> playerData.remove(i));
    }

    private static int getKey(EntityPlayer player) {
        return player == null ? 0 : player.hashCode() << 1 + (player.func_130014_f_().field_72995_K ? 1 : 0);
    }

    public static NBTTagCompound getDataCompoundForPlayer(EntityPlayer player) {
        NBTTagCompound persistentData;
        NBTTagCompound forgeData = player.getEntityData();
        if (!forgeData.func_74764_b("PlayerPersisted")) {
            forgeData.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
        }
        if (!(persistentData = forgeData.func_74775_l("PlayerPersisted")).func_74764_b(DATA_TAG)) {
            persistentData.func_74782_a(DATA_TAG, (NBTBase)new NBTTagCompound());
        }
        return persistentData.func_74775_l(DATA_TAG);
    }

    public static class EventHandler {
        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                PlayerDataHandler.cleanup();
            }
        }

        @SubscribeEvent
        public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            PlayerData data = PlayerDataHandler.get(event.player);
            if (data != null) {
                data.sync();
                data.getRequirementCache().forceClear();
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            PlayerData data;
            if (event.phase == TickEvent.Phase.END && (data = PlayerDataHandler.get(event.player)) != null) {
                data.tickPlayer(event);
            }
        }

        @SubscribeEvent
        public static void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
            PlayerData data = PlayerDataHandler.get(event.getHarvester());
            if (data != null) {
                data.blockDrops(event);
            }
        }

        @SubscribeEvent
        public static void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
            PlayerData data = PlayerDataHandler.get(event.getEntityPlayer());
            if (data != null) {
                data.breakSpeed(event);
            }
        }

        @SubscribeEvent
        public static void onMobDrops(LivingDropsEvent event) {
            PlayerData data;
            if (event.getSource().func_76346_g() instanceof EntityPlayer && (data = PlayerDataHandler.get((EntityPlayer)event.getSource().func_76346_g())) != null) {
                data.mobDrops(event);
            }
        }

        @SubscribeEvent
        public static void onHurt(LivingHurtEvent event) {
            PlayerData data;
            if (event.getEntity() instanceof EntityPlayer && (data = PlayerDataHandler.get((EntityPlayer)event.getEntity())) != null) {
                data.hurt(event);
            }
            if (event.getSource().func_76346_g() instanceof EntityPlayer && (data = PlayerDataHandler.get((EntityPlayer)event.getSource().func_76346_g())) != null) {
                data.attackMob(event);
            }
        }

        @SubscribeEvent
        public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            PlayerData data = PlayerDataHandler.get(event.getEntityPlayer());
            if (data != null) {
                data.rightClickBlock(event);
            }
        }

        @SubscribeEvent
        public static void onEnderTeleport(EnderTeleportEvent event) {
            PlayerData data;
            if (event.getEntity() instanceof EntityPlayer && (data = PlayerDataHandler.get((EntityPlayer)event.getEntity())) != null) {
                data.enderTeleport(event);
            }
        }

        @SubscribeEvent
        public static void onMobDeath(LivingDeathEvent event) {
            PlayerData data;
            if (event.getSource().func_76346_g() instanceof EntityPlayer && (data = PlayerDataHandler.get((EntityPlayer)event.getSource().func_76346_g())) != null) {
                data.killMob(event);
            }
        }
    }
}

