/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.world.gen.feature;

import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.layout.SyslogLayout;

public class WorldgenMonitor
extends AbstractAppender {
    private String modName;
    private BiConsumer<ChunkPos, Integer> consumer;
    private Pattern regex;

    public WorldgenMonitor(String modName, BiConsumer<ChunkPos, Integer> consumer) {
        super(modName + "_worldgen_monitor", null, (Layout)SyslogLayout.newBuilder().build());
        this.modName = modName;
        this.consumer = consumer;
        this.regex = Pattern.compile(modName + " loaded a new chunk \\(([^,]*), ([^,]*)  Dimension: ([^)]*)\\)");
    }

    public static void create(String modName, BiConsumer<ChunkPos, Integer> consumer) {
        WorldgenMonitor appender = new WorldgenMonitor(modName, consumer);
        appender.start();
        ((Logger)FMLLog.log).addAppender((Appender)appender);
    }

    public void append(LogEvent event) {
        String message = event.getMessage().getFormattedMessage();
        Matcher matcher = this.regex.matcher(message);
        if (matcher.find()) {
            int l = Integer.valueOf(matcher.group(1));
            int r = Integer.valueOf(matcher.group(2));
            int d = Integer.valueOf(matcher.group(3));
            this.consumer.accept(new ChunkPos(l, r), d);
        }
    }
}

