/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class ByteArrays {
    public static byte[] completeByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int aByte;
            while ((aByte = inputStream.read()) >= 0) {
                byteArrayOutputStream.write(aByte);
            }
        }
        catch (Exception ignored) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(IOConsumer<ByteArrayOutputStream> consumer) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        consumer.accept(stream);
        return stream.toByteArray();
    }

    @FunctionalInterface
    public static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;

        default public IOConsumer<T> andThen(IOConsumer<? super T> after) {
            Objects.requireNonNull(after);
            return t -> {
                this.accept(t);
                after.accept(t);
            };
        }
    }
}

