/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookCategory;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.button.GuiButtonCategory;
import vazkii.patchouli.client.book.gui.button.GuiButtonEntry;
import vazkii.patchouli.common.book.Book;

public abstract class GuiBookEntryList
extends GuiBook {
    public static final int ENTRIES_PER_PAGE = 13;
    public static final int ENTRIES_IN_FIRST_PAGE = 11;
    BookTextRenderer text;
    List<GuiButton> dependentButtons;
    List<BookEntry> allEntries;
    List<BookEntry> visibleEntries;
    GuiTextField searchField;

    public GuiBookEntryList(Book book) {
        super(book);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.text = new BookTextRenderer(this, this.getDescriptionText(), 15, 40);
        this.visibleEntries = new ArrayList<BookEntry>();
        this.allEntries = new ArrayList<BookEntry>(this.getEntries());
        this.allEntries.removeIf(BookEntry::shouldHide);
        if (this.shouldSortEntryList()) {
            Collections.sort(this.allEntries);
        }
        this.searchField = new GuiTextField(0, this.field_146289_q, 160, 170, 90, 12);
        this.searchField.func_146203_f(32);
        this.searchField.func_146185_a(false);
        this.searchField.func_146205_d(false);
        this.searchField.func_146195_b(true);
        this.dependentButtons = new ArrayList<GuiButton>();
        this.buildEntryButtons();
    }

    protected abstract String getName();

    protected abstract String getDescriptionText();

    protected abstract Collection<BookEntry> getEntries();

    protected boolean doesEntryCountForProgress(BookEntry entry) {
        return true;
    }

    protected boolean shouldDrawProgressBar() {
        return true;
    }

    protected boolean shouldSortEntryList() {
        return true;
    }

    protected void addSubcategoryButtons() {
    }

    @Override
    void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
        super.drawForegroundElements(mouseX, mouseY, partialTicks);
        if (this.page == 0) {
            this.drawCenteredStringNoShadow(this.getName(), 73, 18, this.book.headerColor);
            this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchouli.gui.lexicon.chapters", (Object[])new Object[0]), 199, 18, this.book.headerColor);
            GuiBookEntryList.drawSeparator(this.book, 15, 30);
            GuiBookEntryList.drawSeparator(this.book, 141, 30);
            this.text.render(mouseX, mouseY);
            if (this.shouldDrawProgressBar()) {
                this.drawProgressBar(this.book, mouseX, mouseY, this::doesEntryCountForProgress);
            }
        } else if (this.page % 2 == 1 && this.page == this.maxpages - 1 && this.dependentButtons.size() <= 13) {
            GuiBookEntryList.drawPageFiller(this.book);
        }
        if (!this.searchField.func_146179_b().isEmpty()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiBookEntryList.drawFromTexture(this.book, this.searchField.field_146209_f - 8, this.searchField.field_146210_g, 140, 183, 99, 14);
            boolean unicode = this.field_146289_q.func_82883_a();
            if (!this.book.useBlockyFont) {
                this.field_146289_q.func_78264_a(true);
            }
            this.field_146289_q.func_78276_b(this.searchField.func_146179_b(), this.searchField.field_146209_f + 7, this.searchField.field_146210_g + 1, 0);
            this.field_146289_q.func_78264_a(unicode);
        }
        if (this.visibleEntries.isEmpty()) {
            this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchouli.gui.lexicon.no_results", (Object[])new Object[0]), 199, 80, 0x333333);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
            this.drawCenteredStringNoShadow(I18n.func_135052_a((String)"patchouli.gui.lexicon.sad", (Object[])new Object[0]), 99, 47, 0x999999);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.text.click(mouseX, mouseY, mouseButton);
        this.searchField.func_146192_a(mouseX - this.bookLeft, mouseY - this.bookTop, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (keyCode == 28) {
            if (this.visibleEntries.size() == 1) {
                this.displayLexiconGui(new GuiBookEntry(this.book, this.visibleEntries.get(0)), true);
            }
        } else {
            String currQuery = this.searchField.func_146179_b();
            this.searchField.func_146201_a(typedChar, keyCode);
            if (!this.searchField.func_146179_b().equals(currQuery)) {
                this.buildEntryButtons();
            }
        }
    }

    @Override
    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof GuiButtonCategory) {
            this.displayLexiconGui(new GuiBookCategory(this.book, ((GuiButtonCategory)button).getCategory()), true);
        } else if (button instanceof GuiButtonEntry) {
            GuiBookEntry.displayOrBookmark(this, ((GuiButtonEntry)button).getEntry());
        }
    }

    @Override
    void onPageChanged() {
        this.buildEntryButtons();
    }

    void buildEntryButtons() {
        this.field_146292_n.removeAll(this.dependentButtons);
        this.dependentButtons.clear();
        this.visibleEntries.clear();
        String query = this.searchField.func_146179_b().toLowerCase();
        this.allEntries.stream().filter(e -> e.isFoundByQuery(query)).forEach(this.visibleEntries::add);
        this.maxpages = 1;
        int count = this.visibleEntries.size();
        if ((count -= 11) > 0) {
            this.maxpages += (int)Math.ceil((float)count / 26.0f);
        }
        while (this.getEntryCountStart() > this.visibleEntries.size()) {
            --this.page;
        }
        if (this.page == 0) {
            this.addEntryButtons(141, 38, 0, 11);
            this.addSubcategoryButtons();
        } else {
            int start = this.getEntryCountStart();
            this.addEntryButtons(15, 18, start, 13);
            this.addEntryButtons(141, 18, start + 13, 13);
        }
    }

    int getEntryCountStart() {
        if (this.page == 0) {
            return 0;
        }
        int start = 11;
        return start += 26 * (this.page - 1);
    }

    void addEntryButtons(int x, int y, int start, int count) {
        for (int i = 0; i < count && i + start < this.visibleEntries.size(); ++i) {
            GuiButtonEntry button = new GuiButtonEntry(this, this.bookLeft + x, this.bookTop + y + i * 11, this.visibleEntries.get(start + i), start + i);
            this.field_146292_n.add(button);
            this.dependentButtons.add(button);
        }
    }
}

