/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.morph.common.packet;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.morph.client.morph.MorphInfoClient;
import me.ichun.mods.morph.common.Morph;
import me.ichun.mods.morph.common.morph.MorphInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketUpdateActiveMorphs
extends AbstractPacket {
    public HashMap<String, MorphInfo> infosToSend = new HashMap();

    public PacketUpdateActiveMorphs() {
    }

    public PacketUpdateActiveMorphs(String player) {
        if (player != null) {
            this.infosToSend.put(player, Morph.eventHandlerServer.morphsActive.get(player));
        } else {
            this.infosToSend.putAll(Morph.eventHandlerServer.morphsActive);
        }
    }

    public void writeTo(ByteBuf buffer) {
        PacketBuffer pb = new PacketBuffer(buffer);
        for (Map.Entry<String, MorphInfo> e : this.infosToSend.entrySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)pb, (String)e.getKey());
            pb.func_150786_a(e.getValue().write(new NBTTagCompound()));
        }
        ByteBufUtils.writeUTF8String((ByteBuf)pb, (String)"##endPacket");
    }

    public void readFrom(ByteBuf buffer) {
        PacketBuffer pb = new PacketBuffer(buffer);
        String name = ByteBufUtils.readUTF8String((ByteBuf)pb);
        try {
            while (!name.equals("##endPacket")) {
                NBTTagCompound tag = pb.func_150793_b();
                MorphInfo info = new MorphInfo(null, null, null);
                info.read(tag);
                this.infosToSend.put(name, info);
                name = ByteBufUtils.readUTF8String((ByteBuf)pb);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void execute(Side side, EntityPlayer player) {
        this.handleClient();
    }

    public Side receivingSide() {
        return Side.CLIENT;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient() {
        for (Map.Entry<String, MorphInfo> e : this.infosToSend.entrySet()) {
            if (e.getValue().nextState == null) continue;
            MorphInfoClient info = new MorphInfoClient(null, e.getValue().prevState, e.getValue().nextState);
            info.read(e.getValue().write(new NBTTagCompound()));
            if (Morph.eventHandlerClient.morphsActive.containsKey(e.getKey())) {
                Morph.eventHandlerClient.morphsActive.get(e.getKey()).clean();
            }
            Morph.eventHandlerClient.morphsActive.put(e.getKey(), info);
            if (!e.getKey().equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) continue;
            Morph.eventHandlerClient.renderHandInstance.reset((World)Minecraft.func_71410_x().field_71441_e, info);
        }
    }
}

