/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.world.gen;

import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.config.LootGamesConfig;
import ru.timeconqueror.lootgames.world.gen.DungeonGenerator;

public class LootGamesWorldGen
implements IWorldGenerator {
    private Random rand = new Random();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        LootGames.logHelper.trace("WorldGen => Generate()");
        if (!this.checkSpawnConditions(chunkX, chunkZ, world)) {
            LootGames.logHelper.trace("Stopped this worldgen run");
            return;
        }
        DungeonGenerator dungeonGenerator = new DungeonGenerator();
        dungeonGenerator.generateDungeon(world, (chunkX << 4) + 8, (chunkZ << 4) + 8);
    }

    private boolean checkSpawnConditions(int chunkX, int chunkZ, World world) {
        boolean canSpawn = false;
        if (!LootGamesConfig.worldGen.isDungeonWorldGenEnabled) {
            LootGames.logHelper.trace("WorldGen => Generate() => checkSpawnConditions() => WorldGen is DISABLED");
        } else if (!LootGamesConfig.worldGen.isDimensionEnabledForWG(world.field_73011_w.getDimension())) {
            LootGames.logHelper.trace("WorldGen => Generate() => checkSpawnConditions() => Dim %d is not whitelisted", new Object[]{world.field_73011_w.getDimension()});
        } else if (!this.canSpawnInChunk(chunkX, chunkZ, world)) {
            LootGames.logHelper.trace("WorldGen => Generate() => checkSpawnConditions() => Location not suitable");
        } else {
            LootGames.logHelper.trace("WorldGen => Generate() => canSpawnInChunk() => Location suitable");
            canSpawn = true;
        }
        return canSpawn;
    }

    private boolean canSpawnInChunk(int chunkX, int chunkZ, World world) {
        boolean canSpawn = false;
        int rhombSize = LootGamesConfig.worldGen.getRhombSizeForDim(world.field_73011_w.getDimension());
        int xc = chunkX * 2 + chunkZ;
        int zc = chunkZ * 2 + chunkX;
        this.rand.setSeed(world.func_72905_C() + (long)(xc / (rhombSize * 2)) + (long)(zc / (rhombSize * 2) << 14));
        int pos1 = 3 + this.rand.nextInt(rhombSize * 2 - 3);
        int pos2 = 3 + this.rand.nextInt(rhombSize * 2 - 3);
        int modXC = this.mod(xc, rhombSize * 2);
        int modZC = this.mod(zc, rhombSize * 2);
        if (modXC >= 3 && modZC >= 3 && (modXC == pos1 && modZC == pos2 || modXC == pos1 + 1 && (modZC == pos2 || modZC == pos2 + 1))) {
            canSpawn = true;
        }
        return canSpawn;
    }

    int mod(int x, int div) {
        int r = x % div;
        return r < 0 ? r + div : r;
    }
}

