/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.minigame.minesweeper.block;

import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ru.timeconqueror.lootgames.achievement.AdvancementManager;
import ru.timeconqueror.lootgames.api.block.BlockGame;
import ru.timeconqueror.lootgames.config.LGConfigMinesweeper;
import ru.timeconqueror.lootgames.registry.ModBlocks;
import ru.timeconqueror.lootgames.registry.ModSounds;

public class BlockMSActivator
extends BlockGame {
    public static void generateGameStructure(World world, BlockPos centerPos, int level) {
        int size = Objects.requireNonNull(LGConfigMinesweeper.getStage((int)level)).boardSize;
        BlockPos startPos = centerPos.func_177982_a(-size / 2, 0, -size / 2);
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                BlockPos pos = startPos.func_177982_a(x, 0, z);
                if (x == 0 && z == 0) {
                    world.func_175656_a(pos, ModBlocks.MS_MASTER.func_176223_P());
                    continue;
                }
                world.func_175656_a(pos, ModBlocks.SMART_SUBORDINATE.func_176223_P());
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (playerIn instanceof EntityPlayerMP) {
                AdvancementManager.BLOCK_ACTIVATED.trigger((EntityPlayerMP)playerIn, pos, playerIn.func_184586_b(hand));
            }
            BlockMSActivator.generateGameStructure(worldIn, pos, 1);
            worldIn.func_184133_a(null, pos, ModSounds.msStartGame, SoundCategory.BLOCKS, 0.6f, 1.0f);
        }
        return true;
    }
}

