/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.config;

import java.util.HashMap;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.timecore.api.auxiliary.debug.LogHelper;

@Mod.EventBusSubscriber
@Config.LangKey(value="config.lootgames.category.general")
@Config(modid="lootgames", name="lootgames/lootgames")
public class LootGamesConfig {
    @Config.LangKey(value="config.lootgames.category.worldgen")
    @Config.Comment(value={"Regulates dungeon appearing in world."})
    public static WorldGen worldGen = new WorldGen();
    @Config.LangKey(value="config.lootgames.minigamesenabled")
    public static boolean areMinigamesEnabled = true;
    @Config.LangKey(value="config.lootgames.enabledebug")
    @Config.Comment(value={"If this is equal true, then it will print additional info to log files.", "Default: false"})
    public static boolean enableDebug = false;
    @Config.LangKey(value="config.lootgames.debuglevel")
    @Config.Comment(value={"Available variants: debug, trace", "Debug: additionally prints debug messages.", "Trace: additionally prints debug and trace messages.", "Default: debug"})
    public static String debugLevel = "debug";

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("lootgames")) {
            ConfigManager.sync((String)"lootgames", (Config.Type)Config.Type.INSTANCE);
            LootGamesConfig.initExtras();
        }
    }

    public static void initExtras() {
        LootGames.logHelper.setDebugEnabled(enableDebug);
        LootGames.logHelper.setDebugLevel(debugLevel.equalsIgnoreCase("trace") ? LogHelper.Level.TRACE : LogHelper.Level.DEBUG);
        worldGen.init();
    }

    public static class WorldGen {
        @Config.LangKey(value="config.lootgames.worldgenenabled")
        @Config.Comment(value={"If this is equal true, then dungeon generation will be enabled.", "Default: true"})
        public boolean isDungeonWorldGenEnabled = true;
        @Config.Ignore
        public boolean isDungeonRetroGenEnabled = false;
        @Config.LangKey(value="config.lootgames.dimrhomblist")
        @Config.Comment(value={"Whitelisted dimensions' ids that were allowed for dungeon generation and rhomb size.", "Rhomb size means the size of rhombs, which will imaginary cover the world. Dungeon will be generated in each rhomb.", "So the larger the size, the less chance of generation.", "Rhomb size must be between 5 and 100.", "Example of array element: 0; 20 - this means that dungeons will be generated in rhombs with size equal to 20 in the overworld (ID = 0).", "Default: {0; 20}"})
        public String[] dimAndRhombList = new String[]{"0; 20"};
        private HashMap<Integer, Integer> dimRhombs;

        public void init() {
            this.parseDimAndRhombList();
        }

        public boolean isDimensionEnabledForWG(int worldID) {
            return this.dimRhombs.get(worldID) != null;
        }

        public int getRhombSizeForDim(int dimensionID) {
            return this.dimRhombs.get(dimensionID);
        }

        private void parseDimAndRhombList() {
            this.dimRhombs = new HashMap();
            for (String entry : this.dimAndRhombList) {
                if (entry.length() == 0) {
                    return;
                }
                String[] arr = entry.split(";");
                if (arr.length != 2) {
                    LootGames.logHelper.error("Invalid dimension rhomb entry found: {}. Syntax is <dimensionID>;<rhomb size>. This entry will be skipped.", new Object[]{entry});
                }
                try {
                    int dimID = Integer.parseInt(arr[0].trim());
                    int rhombSize = Integer.parseInt(arr[1].trim());
                    if (rhombSize < 5 || rhombSize > 100) {
                        LootGames.logHelper.error("Invalid dimension rhomb entry found: {}. Rhomb size must be between 5 and 100.", new Object[]{entry});
                        continue;
                    }
                    if (!this.dimRhombs.containsKey(dimID)) {
                        this.dimRhombs.put(dimID, rhombSize);
                        LootGames.logHelper.info("Worldgen enabled in dimension {} with rhomb size {}.", new Object[]{dimID, rhombSize});
                        continue;
                    }
                    LootGames.logHelper.error("Invalid dimension rhomb entry found: {}. DimensionID is already defined.", new Object[]{entry});
                }
                catch (NumberFormatException e) {
                    LootGames.logHelper.error("Invalid dimension rhomb entry found: {}. DimensionID or Rhomb size is not an Integer. This entry will be skipped.", new Object[]{entry});
                }
            }
        }
    }
}

