/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.util;

import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public enum DirectionOctagonal implements IStringSerializable
{
    NORTH(0, "north", 0, -1),
    NORTH_EAST(1, "north_east", 1, -1),
    EAST(2, "east", 1, 0),
    SOUTH_EAST(3, "south_east", 1, 1),
    SOUTH(4, "south", 0, 1),
    SOUTH_WEST(5, "south_west", -1, 1),
    WEST(6, "west", -1, 0),
    NORTH_WEST(7, "north_west", -1, -1);

    private static final DirectionOctagonal[] LOOKUP;
    private final String name;
    private final int index;
    private final int offsetX;
    private final int offsetZ;

    private DirectionOctagonal(int index, String name, int offsetX, int offsetZ) {
        this.index = index;
        this.name = name;
        this.offsetX = offsetX;
        this.offsetZ = offsetZ;
    }

    public static DirectionOctagonal byIndex(int index) {
        return LOOKUP[index];
    }

    @NotNull
    public String func_176610_l() {
        return this.name;
    }

    public BlockPos getMasterBlockPos(BlockPos subordinatePos) {
        return subordinatePos.func_177982_a(this.offsetX != 0 ? -this.offsetX : 0, 0, this.offsetZ != 0 ? -this.offsetZ : 0);
    }

    public BlockPos getOffsetBlockPos(BlockPos center) {
        return center.func_177982_a(this.getOffsetX(), 0, this.getOffsetZ());
    }

    public int getIndex() {
        return this.index;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public String toString() {
        return this.name;
    }

    static {
        LOOKUP = new DirectionOctagonal[DirectionOctagonal.values().length];
        DirectionOctagonal[] directionOctagonalArray = DirectionOctagonal.values();
        int n = directionOctagonalArray.length;
        for (int i = 0; i < n; ++i) {
            DirectionOctagonal value;
            DirectionOctagonal.LOOKUP[value.index] = value = directionOctagonalArray[i];
        }
    }
}

