/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.task;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.api.task.ITask;
import ru.timeconqueror.lootgames.api.task.TaskRegistry;

public class TEPostponeTaskScheduler
implements INBTSerializable<NBTTagList> {
    private final ArrayList<TaskWrapper> tasks = new ArrayList();
    private final TileEntity tileEntity;

    public TEPostponeTaskScheduler(TileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(ITask task, int timeBeforeStart) {
        ArrayList<TaskWrapper> arrayList = this.tasks;
        synchronized (arrayList) {
            this.tasks.add(new TaskWrapper(timeBeforeStart, task));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdate() {
        ArrayList<TaskWrapper> arrayList = this.tasks;
        synchronized (arrayList) {
            Iterator<TaskWrapper> iterator = this.tasks.iterator();
            while (iterator.hasNext()) {
                TaskWrapper task = iterator.next();
                if (task.timeBeforeStart <= 0) {
                    task.run(this.tileEntity.func_145831_w());
                    iterator.remove();
                    continue;
                }
                task.decreaseTimer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTTagList serializeNBT() {
        NBTTagList out = new NBTTagList();
        ArrayList<TaskWrapper> arrayList = this.tasks;
        synchronized (arrayList) {
            for (TaskWrapper wrapper : this.tasks) {
                NBTTagCompound element = new NBTTagCompound();
                element.func_74782_a("task", wrapper.task.serializeNBT());
                element.func_74768_a("time", wrapper.timeBeforeStart);
                element.func_74778_a("name", wrapper.task.getClass().getName());
                out.func_74742_a((NBTBase)element);
            }
        }
        return out;
    }

    public void deserializeNBT(NBTTagList nbt) {
        for (NBTBase in : nbt) {
            ITask task;
            NBTTagCompound c = (NBTTagCompound)in;
            int time = c.func_74762_e("time");
            Class<? extends ITask> taskClass = TaskRegistry.getTaskClass(c.func_74779_i("name"));
            if (taskClass == null) {
                LootGames.logHelper.error("You didn't register task class {} in TaskRegistry. It will be skipped.", new Object[]{c.func_74779_i("name")});
                return;
            }
            try {
                task = taskClass.newInstance();
                task.deserializeNBT((NBTBase)c.func_74775_l("task"));
            }
            catch (IllegalAccessException | InstantiationException e) {
                LootGames.logHelper.error("Can't create task {} while restoring world from save. It will be skipped.", new Object[]{taskClass});
                e.printStackTrace();
                return;
            }
            this.tasks.add(new TaskWrapper(time, task));
        }
    }

    private static class TaskWrapper {
        private int timeBeforeStart;
        private ITask task;

        private TaskWrapper(int timeBeforeStart, ITask task) {
            this.timeBeforeStart = timeBeforeStart;
            this.task = task;
        }

        private void decreaseTimer() {
            --this.timeBeforeStart;
        }

        private void run(World world) {
            this.task.run(world);
        }
    }
}

