/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.server;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.common.packet.LittleNeighborUpdatePacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class NeighborUpdateOrganizer {
    private HashMapList<World, BlockPos> positions = new HashMapList();

    public NeighborUpdateOrganizer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void add(World world, BlockPos pos) {
        if (world instanceof IOrientatedWorld) {
            return;
        }
        if (!this.positions.contains((Object)world, (Object)pos)) {
            this.positions.add((Object)world, (Object)pos);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (Map.Entry entry : this.positions.entrySet()) {
                World world = (World)entry.getKey();
                if (world instanceof WorldServer) {
                    HashMapList chunks = new HashMapList();
                    for (BlockPos pos : (ArrayList)entry.getValue()) {
                        chunks.add((Object)new ChunkPos(pos), (Object)pos);
                    }
                    for (EntityPlayer player : world.field_73010_i) {
                        ArrayList<BlockPos> collected = new ArrayList<BlockPos>();
                        for (Map.Entry chunk : chunks.entrySet()) {
                            if (!((WorldServer)world).func_184164_w().func_72694_a((EntityPlayerMP)player, ((ChunkPos)chunk.getKey()).field_77276_a, ((ChunkPos)chunk.getKey()).field_77275_b)) continue;
                            collected.addAll((Collection)chunk.getValue());
                        }
                        if (collected.isEmpty()) continue;
                        PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleNeighborUpdatePacket(world, collected), (EntityPlayerMP)((EntityPlayerMP)player));
                    }
                    continue;
                }
                if (!(world instanceof SubWorld)) continue;
                PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new LittleNeighborUpdatePacket(world, (List)entry.getValue()), (Entity)((SubWorld)world).parent, (WorldServer)((WorldServer)((SubWorld)world).getRealWorld()), null);
            }
            this.positions.clear();
        }
    }
}

