/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.place;

import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.place.PlacePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.math.BlockPos;

public class PlaceModeFill
extends PlacementMode {
    public PlaceModeFill(String name, PlacementMode.PreviewMode mode) {
        super(name, mode, false);
    }

    @Override
    public boolean checkAll() {
        return false;
    }

    @Override
    public List<BlockPos> getCoordsToCheck(HashMap<BlockPos, PlacePreviews> splittedTiles, BlockPos pos) {
        return null;
    }

    @Override
    public List<LittleTile> placeTile(TileEntityLittleTiles te, LittleTile tile, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, boolean requiresCollisionTest) {
        LittleTile newTile;
        ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
        if (!requiresCollisionTest) {
            tiles.add(tile);
            return tiles;
        }
        ArrayList<LittleBox> cutout = new ArrayList<LittleBox>();
        List<LittleBox> boxes = te.cutOut(tile.box, cutout);
        for (LittleBox box : boxes) {
            newTile = tile.copy();
            newTile.box = box;
            tiles.add(newTile);
        }
        for (LittleBox box : cutout) {
            newTile = tile.copy();
            newTile.box = box;
            unplaceableTiles.add(newTile);
        }
        return tiles;
    }
}

