/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.grid;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.tile.math.LittleUtils;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class LittleGridContext {
    public static final int overallDefault = 16;
    @Deprecated
    public static final int oldHalfGridSize = 8;
    public static int[] gridSizes;
    public static int minSize;
    public static int multiplier;
    public static int defaultSize;
    private static int defaultSizeIndex;
    public static LittleGridContext[] context;
    public final int size;
    public final int maxPos;
    public final int maxTilesPerPlane;
    public final int maxTilesPerBlock;
    public final double pixelSize;
    public final double pixelVolume;
    public final boolean isDefault;
    public final int index;
    public final LittleVec rotationCenter;
    public final int[] minSizes;

    public static LittleGridContext loadGrid(int min, int defaultGrid, int scale, int multiplier) {
        minSize = min;
        defaultSize = defaultGrid;
        gridSizes = new int[scale];
        context = new LittleGridContext[scale];
        LittleGridContext.multiplier = multiplier;
        int size = min;
        for (int i = 0; i < gridSizes.length; ++i) {
            LittleGridContext.gridSizes[i] = size;
            LittleGridContext.context[i] = new LittleGridContext(size, i);
            if (LittleGridContext.context[i].isDefault) {
                defaultSizeIndex = i;
            }
            size *= multiplier;
        }
        return LittleGridContext.get();
    }

    public static List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < context.length; ++i) {
            names.add(LittleGridContext.context[i].size + "");
        }
        return names;
    }

    public static LittleGridContext get(int size) {
        if (defaultSize == size) {
            return context[defaultSizeIndex];
        }
        for (int i = 0; i < context.length; ++i) {
            if (LittleGridContext.context[i].size != size) continue;
            return context[i];
        }
        throw new RuntimeException("Invalid gridsize = '" + size + "'!");
    }

    public static LittleGridContext get() {
        return context[defaultSizeIndex];
    }

    public static LittleGridContext get(NBTTagCompound nbt) {
        if (nbt.func_74764_b("grid")) {
            return LittleGridContext.get(nbt.func_74762_e("grid"));
        }
        return LittleGridContext.get();
    }

    public static LittleGridContext getOverall(NBTTagCompound nbt) {
        if (nbt.func_74764_b("grid")) {
            return LittleGridContext.get(nbt.func_74762_e("grid"));
        }
        return LittleGridContext.get(16);
    }

    public static LittleGridContext getMin() {
        return context[0];
    }

    public static LittleGridContext getMax() {
        return context[context.length - 1];
    }

    public static LittleGridContext max(LittleGridContext context, LittleGridContext context2) {
        if (context.size >= context2.size) {
            return context;
        }
        return context2;
    }

    public static void remove(NBTTagCompound nbt) {
        nbt.func_82580_o("grid");
    }

    protected LittleGridContext(int gridSize, int index) {
        this.index = index;
        this.size = gridSize;
        this.pixelSize = 1.0 / (double)gridSize;
        this.maxPos = gridSize;
        this.maxTilesPerPlane = gridSize * gridSize;
        this.maxTilesPerBlock = gridSize * gridSize * gridSize;
        this.pixelVolume = Math.max(Double.MIN_VALUE, 1.0 / (double)this.maxTilesPerBlock);
        this.isDefault = defaultSize == gridSize;
        this.minSizes = new int[this.size];
        this.minSizes[0] = minSize;
        for (int i = 1; i < this.minSizes.length; ++i) {
            this.minSizes[i] = this.size / IntMath.gcd((int)i, (int)this.size);
            if (this.minSizes[i] >= minSize && this.minSizes[i] % minSize == 0) continue;
            this.minSizes[i] = this.size;
        }
        this.rotationCenter = new LittleVec(this.size, this.size, this.size);
    }

    public void set(NBTTagCompound nbt) {
        if (!this.isDefault || LittleTiles.CONFIG.core.forceToSaveDefaultSize) {
            nbt.func_74768_a("grid", this.size);
        } else {
            nbt.func_82580_o("grid");
        }
    }

    public void setOverall(NBTTagCompound nbt) {
        if (this.size != 16) {
            nbt.func_74768_a("grid", this.size);
        }
    }

    public int getMinGrid(int value) {
        return this.minSizes[Math.abs(value % this.size)];
    }

    public double toVanillaGrid(double grid) {
        return grid * this.pixelSize;
    }

    public float toVanillaGrid(float grid) {
        return (float)((double)grid * this.pixelSize);
    }

    public double toVanillaGrid(long grid) {
        return (double)grid * this.pixelSize;
    }

    public double toVanillaGrid(int grid) {
        return (double)grid * this.pixelSize;
    }

    public int toBlockOffset(long grid) {
        if (grid > 0L) {
            return (int)(grid / (long)this.size);
        }
        return (int)Math.floor((double)grid / (double)this.size);
    }

    public int toBlockOffset(int grid) {
        if (grid > 0) {
            return grid / this.size;
        }
        return (int)Math.floor((double)grid / (double)this.size);
    }

    public boolean isAtEdge(double pos) {
        return pos % this.pixelSize == 0.0;
    }

    public int toGrid(int pos) {
        return pos * this.size;
    }

    public long toGridAccurate(double pos) {
        if ((pos = LittleUtils.round(pos * (double)this.size)) < 0.0) {
            return (long)Math.floor(pos);
        }
        return (long)pos;
    }

    public int toGrid(double pos) {
        if ((pos = LittleUtils.round(pos * (double)this.size)) < 0.0) {
            return (int)Math.floor(pos);
        }
        return (int)pos;
    }

    public LittleGridContext ensureContext(LittleGridContext context) {
        if (context.size > this.size) {
            return context;
        }
        return this;
    }

    public String toString() {
        return "" + this.size;
    }
}

