/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.animation;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.common.structure.type.door.LittleAdvancedDoor;
import com.creativemd.littletiles.common.util.animation.AnimationKey;
import com.creativemd.littletiles.common.util.animation.AnimationState;
import com.creativemd.littletiles.common.util.animation.ValueTimeline;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class AnimationTimeline {
    public int duration;
    public PairList<AnimationKey, ValueTimeline> values;

    public AnimationTimeline(NBTTagCompound nbt) {
        this.duration = nbt.func_74762_e("duration");
        this.values = new PairList();
        if (nbt.func_74764_b("values")) {
            NBTTagList list = nbt.func_150295_c("values", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound valueNBT = list.func_150305_b(i);
                this.values.add((Object)AnimationKey.getKey(valueNBT.func_74779_i("key")), (Object)ValueTimeline.read(valueNBT.func_74759_k("data")));
            }
        } else {
            NBTTagList list = nbt.func_150295_c("animations", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound animationNBT = list.func_150305_b(i);
                this.values = AnimationTimeline.getAnimation((int)animationNBT.func_74763_f("time"), animationNBT.func_74762_e("type"), animationNBT.func_74759_k("data"));
            }
        }
    }

    public static PairList<AnimationKey, ValueTimeline> getAnimation(int begin, int type, int[] array) {
        PairList values = new PairList();
        long duration = (long)array[0] << 32 | (long)array[1] & 0xFFFFFFFFL;
        if (type == 0 || type == 1) {
            double endZ;
            double endY;
            double endX;
            double startZ;
            double startY;
            double startX;
            if (array.length == 8) {
                startX = array[2];
                startY = array[3];
                startZ = array[4];
                endX = array[5];
                endY = array[6];
                endZ = array[7];
            } else {
                startX = Double.longBitsToDouble((long)array[2] << 32 | (long)array[3] & 0xFFFFFFFFL);
                startY = Double.longBitsToDouble((long)array[4] << 32 | (long)array[5] & 0xFFFFFFFFL);
                startZ = Double.longBitsToDouble((long)array[6] << 32 | (long)array[7] & 0xFFFFFFFFL);
                endX = Double.longBitsToDouble((long)array[8] << 32 | (long)array[9] & 0xFFFFFFFFL);
                endY = Double.longBitsToDouble((long)array[10] << 32 | (long)array[11] & 0xFFFFFFFFL);
                endZ = Double.longBitsToDouble((long)array[12] << 32 | (long)array[13] & 0xFFFFFFFFL);
            }
            switch (type) {
                case 0: {
                    ValueTimeline.CosineTimeline timeline;
                    if (startX != 0.0 || endX != 0.0) {
                        timeline = new ValueTimeline.CosineTimeline();
                        timeline.addPoint(begin, startX);
                        timeline.addPoint(begin + (int)duration, endX);
                        values.add((Object)AnimationKey.offX, (Object)timeline);
                    }
                    if (startY != 0.0 || endY != 0.0) {
                        timeline = new ValueTimeline.CosineTimeline();
                        timeline.addPoint(begin, startY);
                        timeline.addPoint(begin + (int)duration, endY);
                        values.add((Object)AnimationKey.offY, (Object)timeline);
                    }
                    if (startZ != 0.0 || endZ != 0.0) {
                        timeline = new ValueTimeline.CosineTimeline();
                        timeline.addPoint(begin, startZ);
                        timeline.addPoint(begin + (int)duration, endZ);
                        values.add((Object)AnimationKey.offZ, (Object)timeline);
                    }
                    return values;
                }
                case 1: {
                    ValueTimeline.CosineTimeline timeline;
                    if (startX != 0.0 || endX != 0.0) {
                        timeline = new ValueTimeline.CosineTimeline();
                        timeline.addPoint(begin, startX);
                        timeline.addPoint(begin + (int)duration, endX);
                        values.add((Object)AnimationKey.rotX, (Object)timeline);
                    }
                    if (startY != 0.0 || endY != 0.0) {
                        timeline = new ValueTimeline.CosineTimeline();
                        timeline.addPoint(begin, startY);
                        timeline.addPoint(begin + (int)duration, endY);
                        values.add((Object)AnimationKey.rotY, (Object)timeline);
                    }
                    if (startZ != 0.0 || endZ != 0.0) {
                        timeline = new ValueTimeline.CosineTimeline();
                        timeline.addPoint(begin, startZ);
                        timeline.addPoint(begin + (int)duration, endZ);
                        values.add((Object)AnimationKey.rotZ, (Object)timeline);
                    }
                    return values;
                }
            }
        } else {
            int index = 2;
            for (int step = 0; step < 6; ++step) {
                int size = array[index];
                ++index;
                if (size != 0) {
                    PairList<Integer, Double> list = LittleAdvancedDoor.loadPairListDouble(array, index, size);
                    ValueTimeline timeline = new ValueTimeline.LinearTimeline().addPoints(list);
                    AnimationKey key = null;
                    switch (step) {
                        case 0: {
                            key = AnimationKey.offX;
                            break;
                        }
                        case 1: {
                            key = AnimationKey.offY;
                            break;
                        }
                        case 2: {
                            key = AnimationKey.offZ;
                            break;
                        }
                        case 3: {
                            key = AnimationKey.rotX;
                            break;
                        }
                        case 4: {
                            key = AnimationKey.rotY;
                            break;
                        }
                        case 5: {
                            key = AnimationKey.rotZ;
                        }
                    }
                    values.add((Object)key, (Object)timeline);
                }
                index += size;
            }
            return values;
        }
        return null;
    }

    public AnimationTimeline(int duration, PairList<AnimationKey, ValueTimeline> values) {
        this.duration = duration;
        this.values = values;
    }

    public boolean tick(int tick, AnimationState state) {
        if (tick > this.duration) {
            return false;
        }
        for (Pair pair : this.values) {
            state.set((AnimationKey)pair.key, ((ValueTimeline)pair.value).value(tick));
        }
        return true;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("duration", this.duration);
        NBTTagList list = new NBTTagList();
        for (Pair pair : this.values) {
            NBTTagCompound valueNBT = new NBTTagCompound();
            valueNBT.func_74778_a("key", ((AnimationKey)pair.key).name);
            valueNBT.func_74783_a("data", ((ValueTimeline)pair.value).write());
            list.func_74742_a((NBTBase)valueNBT);
        }
        nbt.func_74782_a("values", (NBTBase)list);
        return nbt;
    }

    public void offset(int offset) {
        this.duration += offset;
        for (Pair pair : this.values) {
            ((ValueTimeline)pair.value).offset(offset);
        }
    }

    public void transform(Rotation rotation) {
        PairList newPairs = new PairList();
        for (Pair pair : this.values) {
            Pair<AnimationKey, Double> result = ((AnimationKey)pair.key).transform(rotation, 1.0);
            if (result != null) {
                if ((Double)result.value < 0.0) {
                    ((ValueTimeline)pair.value).flip();
                }
                newPairs.add(result.key, pair.value);
                continue;
            }
            newPairs.add(pair);
        }
        this.values = newPairs;
    }

    public boolean isFirstAligned() {
        for (Pair pair : this.values) {
            if (((AnimationKey)pair.key).isAligned(((ValueTimeline)pair.value).first((AnimationKey)pair.key))) continue;
            return false;
        }
        return true;
    }
}

