/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.combine;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.combine.AdvancedCombiner;
import com.creativemd.littletiles.common.tile.combine.StructureCombiner;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import java.util.List;

public class BasicCombiner {
    protected List<LittleBox> boxes;
    protected int i;
    protected int j;
    protected boolean modified;

    public static boolean combineBoxes(List<LittleBox> boxes) {
        return new BasicCombiner(boxes).combine();
    }

    public static boolean combineTiles(List<LittleTile> tiles) {
        return new AdvancedCombiner<LittleTile>(tiles).combine();
    }

    public static boolean combineTiles(List<LittleTile> tiles, LittleStructure structure) {
        return new StructureCombiner(tiles, structure).combine();
    }

    public static boolean combinePreviews(List<LittlePreview> previews) {
        return new AdvancedCombiner<LittlePreview>(previews).combine();
    }

    public BasicCombiner(List<LittleBox> boxes) {
        this.boxes = boxes;
    }

    public void set(List<LittleBox> boxes) {
        if (this.getClass() != BasicCombiner.class) {
            throw new RuntimeException("Illegal action! Boxes cannot be set for advanced combiners!");
        }
        this.boxes = boxes;
    }

    public List<LittleBox> getBoxes() {
        return this.boxes;
    }

    public boolean combine() {
        int sizeBefore = this.boxes.size();
        this.modified = true;
        while (this.modified) {
            this.modified = false;
            this.i = 0;
            while (this.i < this.boxes.size()) {
                this.j = 0;
                while (this.j < this.boxes.size()) {
                    LittleBox box;
                    if (this.i != this.j && (box = this.boxes.get(this.i).combineBoxes(this.boxes.get(this.j), this)) != null) {
                        this.boxes.set(this.i, box);
                        this.boxes.remove(this.j);
                        this.modified = true;
                        if (this.i <= this.j) continue;
                        --this.i;
                        continue;
                    }
                    ++this.j;
                }
                ++this.i;
            }
        }
        boolean changed = sizeBefore != this.boxes.size();
        this.boxes = null;
        return changed;
    }

    public boolean cutOut(LittleBox searching) {
        boolean intersects = false;
        for (LittleBox box : this.boxes) {
            if (searching.getClass() != box.getClass()) continue;
            if (box.containsBox(searching)) {
                List<LittleBox> cutOut = box.cutOut(searching);
                if (cutOut != null) {
                    this.boxes.addAll(cutOut);
                }
                this.removeBox(box);
                return true;
            }
            if (!LittleBox.intersectsWith(box, searching)) continue;
            intersects = true;
            break;
        }
        if (intersects) {
            LittleVec size = searching.getSize();
            boolean[][][] filled = new boolean[size.x][size.y][size.z];
            for (LittleBox box : this.boxes) {
                if (!LittleBox.intersectsWith(box, searching) || searching.getClass() != box.getClass()) continue;
                box.fillInSpace(searching, filled);
            }
            for (int x = 0; x < filled.length; ++x) {
                for (int y = 0; y < filled[x].length; ++y) {
                    for (int z = 0; z < filled[x][y].length; ++z) {
                        if (filled[x][y][z]) continue;
                        return false;
                    }
                }
            }
            int i = 0;
            while (i < this.boxes.size()) {
                LittleBox box = this.boxes.get(i);
                if (LittleBox.intersectsWith(box, searching) && searching.getClass() == box.getClass()) {
                    List<LittleBox> cutOut = box.cutOut(searching);
                    if (cutOut != null) {
                        this.boxes.addAll(cutOut);
                    }
                    this.removeBox(box);
                    continue;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void removeBox(LittleBox box) {
        int index = this.boxes.indexOf(box);
        if (index != -1) {
            if (this.i > index) {
                --this.i;
            }
            if (this.j > index) {
                --this.j;
            }
            this.modified = true;
            this.removeBox(index);
        }
    }

    protected void removeBox(int index) {
        this.boxes.remove(index);
    }
}

