/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.door;

import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.creativecore.common.utils.type.UUIDSupplier;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.connection.IStructureChildConnector;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.util.animation.AnimationKey;
import com.creativemd.littletiles.common.util.animation.AnimationTimeline;
import com.creativemd.littletiles.common.util.animation.ValueTimeline;
import com.creativemd.littletiles.common.util.animation.event.AnimationEvent;
import com.creativemd.littletiles.common.util.animation.event.ChildActivateEvent;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.ArrayUtils;

public class LittleDoorActivator
extends LittleDoor {
    public int[] toActivate;

    public LittleDoorActivator(LittleStructureType type) {
        super(type);
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        nbt.func_74783_a("activate", this.toActivate);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        this.toActivate = nbt.func_74759_k("activate");
    }

    public LittleDoor getChildrenDoor(int index) {
        if (index >= 0 && index < this.children.size()) {
            LittleStructure structure = ((IStructureChildConnector)this.children.get(index)).getStructure(this.getWorld());
            if (structure instanceof LittleDoor) {
                return (LittleDoor)structure;
            }
            return null;
        }
        return null;
    }

    @Override
    public EntityAnimation openDoor(@Nullable EntityPlayer player, UUIDSupplier uuid, LittleDoor.DoorOpeningResult result, boolean tickOnce) {
        for (int i : this.toActivate) {
            EntityAnimation childAnimation;
            LittleDoor child = this.getChildrenDoor(i);
            if (child == null || (childAnimation = child.openDoor(player, uuid, result, tickOnce)) == null) continue;
            childAnimation.controller.onServerApproves();
        }
        return null;
    }

    @Override
    public int getCompleteDuration() {
        int duration = 0;
        for (int i : this.toActivate) {
            LittleDoor child = this.getChildrenDoor(i);
            if (child == null) continue;
            duration = Math.max(duration, child.getCompleteDuration());
        }
        return duration;
    }

    @Override
    public List<LittleDoor> collectDoorsToCheck() {
        ArrayList<LittleDoor> doors = new ArrayList<LittleDoor>();
        for (int i : this.toActivate) {
            LittleDoor child = this.getChildrenDoor(i);
            if (child == null) continue;
            doors.add(child);
        }
        return doors;
    }

    @Override
    public boolean isInMotion() {
        for (int i : this.toActivate) {
            LittleDoor child = this.getChildrenDoor(i);
            if (child == null || !child.isInMotion()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void fillActivateChildren(BitSet set) {
        for (int i : this.toActivate) {
            set.set(i);
        }
    }

    public static class LittleDoorActivatorParser
    extends LittleStructureGuiParser {
        public List<Integer> possibleChildren;

        public LittleDoorActivatorParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        public String getDisplayName(LittlePreviews previews, int childId) {
            String name = previews.getStructureName();
            if (name == null) {
                name = previews.hasStructure() ? previews.getStructureId() : "none";
            }
            return name + " " + childId;
        }

        @Override
        public void createControls(LittlePreviews previews, LittleStructure structure) {
            this.parent.controls.add(new GuiCheckBox("rightclick", CoreControl.translate((String)"gui.door.rightclick"), 0, 123, structure instanceof LittleDoor ? !((LittleDoor)structure).disableRightClick : true));
            GuiScrollBox box = new GuiScrollBox("content", 0, 0, 100, 115);
            this.parent.controls.add(box);
            LittleDoorActivator activator = structure instanceof LittleDoorActivator ? (LittleDoorActivator)structure : null;
            this.possibleChildren = new ArrayList<Integer>();
            int i = 0;
            int added = 0;
            for (LittlePreviews child : previews.getChildren()) {
                Class<? extends LittleStructure> clazz = LittleStructureRegistry.getStructureClass(child.getStructureId());
                if (clazz != null && LittleDoor.class.isAssignableFrom(clazz)) {
                    box.addControl((GuiControl)new GuiCheckBox("" + i, this.getDisplayName(child, i), 0, added * 20, activator != null && ArrayUtils.contains((int[])activator.toActivate, (int)i)));
                    this.possibleChildren.add(i);
                    ++added;
                }
                ++i;
            }
            this.updateTimeline();
        }

        @CustomEventSubscribe
        public void onChanged(GuiControlChangedEvent event) {
            if (event.source instanceof GuiCheckBox) {
                this.updateTimeline();
            }
        }

        public void updateTimeline() {
            AnimationTimeline timeline = new AnimationTimeline(0, (PairList<AnimationKey, ValueTimeline>)new PairList());
            ArrayList<AnimationEvent> events = new ArrayList<AnimationEvent>();
            for (Integer integer : this.possibleChildren) {
                GuiCheckBox box = (GuiCheckBox)this.parent.get("" + integer);
                if (box == null || !box.value) continue;
                events.add(new ChildActivateEvent(0, integer));
            }
            this.handler.setTimeline(timeline, events);
        }

        @Override
        public LittleStructure parseStructure(LittlePreviews previews) {
            LittleDoorActivator activator = this.createStructure(LittleDoorActivator.class);
            GuiCheckBox rightclick = (GuiCheckBox)this.parent.get("rightclick");
            activator.disableRightClick = !rightclick.value;
            GuiScrollBox box = (GuiScrollBox)this.parent.get("content");
            ArrayList<Integer> toActivate = new ArrayList<Integer>();
            for (Integer integer : this.possibleChildren) {
                GuiCheckBox checkBox = (GuiCheckBox)box.get("" + integer);
                if (checkBox == null || !checkBox.value) continue;
                toActivate.add(integer);
            }
            activator.toActivate = new int[toActivate.size()];
            for (int i = 0; i < activator.toActivate.length; ++i) {
                activator.toActivate[i] = (Integer)toActivate.get(i);
            }
            return activator;
        }
    }
}

