/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.tile.LittleRenderingCube;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.IAnimatedStructure;
import com.creativemd.littletiles.common.structure.connection.IStructureChildConnector;
import com.creativemd.littletiles.common.structure.connection.StructureLink;
import com.creativemd.littletiles.common.structure.connection.StructureLinkFromSubWorld;
import com.creativemd.littletiles.common.structure.connection.StructureLinkTile;
import com.creativemd.littletiles.common.structure.connection.StructureLinkToSubWorld;
import com.creativemd.littletiles.common.structure.connection.StructureMainTile;
import com.creativemd.littletiles.common.structure.exception.MissingTileEntity;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.identifier.LittleIdentifierRelative;
import com.creativemd.littletiles.common.tile.math.identifier.LittleIdentifierStructureAbsolute;
import com.creativemd.littletiles.common.tile.math.identifier.LittleIdentifierStructureRelative;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVecContext;
import com.creativemd.littletiles.common.tile.math.vec.RelativeBlockPos;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviewsStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.vec.LittleTransformation;
import com.creativemd.littletiles.common.util.vec.SurroundingBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleStructure {
    private static final Iterator<LittleTile> EMPTY_ITERATOR = new Iterator<LittleTile>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public LittleTile next() {
            return null;
        }
    };
    private static final HashMapList<BlockPos, LittleTile> EMPTY_HASHMAPLIST = new HashMapList();
    public final LittleStructureType type;
    public String name;
    private LittleTile mainTile;
    protected LittleAbsoluteVec lastMainTileVec = null;
    protected HashMapList<BlockPos, LittleTile> tiles = null;
    public LinkedHashMap<BlockPos, Integer> tilesToLoad = null;
    public IStructureChildConnector parent;
    public List<IStructureChildConnector> children;
    private List<LittleStructure> tempChildren;

    public static LittleStructure createAndLoadStructure(NBTTagCompound nbt, @Nullable LittleTile mainTile) {
        if (nbt == null) {
            return null;
        }
        String id = nbt.func_74779_i("id");
        LittleStructureType type = LittleStructureRegistry.getStructureType(id);
        if (type != null) {
            LittleStructure structure = type.createStructure();
            structure.mainTile = mainTile;
            structure.loadFromNBT(nbt);
            return structure;
        }
        System.out.println("Could not find structureID=" + id);
        return null;
    }

    public LittleStructure(LittleStructureType type) {
        this.type = type;
    }

    public World getWorld() {
        return this.mainTile.te.func_145831_w();
    }

    public int getAttribute() {
        return this.type.attribute;
    }

    public LittleTile getMainTile() {
        return this.mainTile;
    }

    public LittleIdentifierStructureAbsolute getAbsoluteIdentifier() {
        return new LittleIdentifierStructureAbsolute(this.mainTile, this.getAttribute());
    }

    public boolean hasMainTile() {
        return this.mainTile != null;
    }

    public boolean isStructurePlaced() {
        return this.hasMainTile();
    }

    public boolean selectMainTile() {
        LittleTile first;
        if (this.load() && (first = (LittleTile)this.tiles.getFirst()) != null) {
            this.setMainTile(first);
            return true;
        }
        return false;
    }

    public void setMainTile(LittleTile tile) {
        if (this.isStructurePlaced()) {
            this.checkLoaded();
        }
        this.mainTile = tile;
        this.mainTile.connection = new StructureMainTile(this.mainTile, this);
        World world = this.getWorld();
        if (this.parent != null) {
            Iterator parentStructure = this.parent.getStructure(world);
            ((LittleStructure)((Object)parentStructure)).updateChildConnection(this.parent.getChildID(), this);
            this.updateParentConnection(this.parent.getChildID(), (LittleStructure)((Object)parentStructure));
        }
        for (IStructureChildConnector child : this.children) {
            LittleStructure childStructure = child.getStructure(world);
            childStructure.updateParentConnection(child.getChildID(), this);
            this.updateChildConnection(child.getChildID(), childStructure);
        }
        if (this.tiles == null) {
            this.tiles = new HashMapList();
            this.tiles.add((Object)this.mainTile.getBlockPos(), (Object)this.mainTile);
        } else if (!this.contains(tile)) {
            this.add(tile);
        }
        for (Map.Entry entry : this.tiles.entrySet()) {
            try {
                TileEntityLittleTiles te = this.loadTE((BlockPos)entry.getKey());
                world.func_175646_b((BlockPos)entry.getKey(), (TileEntity)te);
                for (LittleTile stTile : (ArrayList)entry.getValue()) {
                    if (stTile == this.mainTile) continue;
                    stTile.connection = this.getStructureLink(stTile);
                    stTile.connection.setLoadedStructure(this);
                }
            }
            catch (MissingTileEntity e) {
                this.markToBeLoaded((BlockPos)entry.getKey());
                e.printStackTrace();
            }
        }
        LittleAbsoluteVec absolute = tile.getAbsolutePos();
        if (this.lastMainTileVec != null) {
            LittleVecContext vec = this.lastMainTileVec.getRelative(absolute);
            if (!this.lastMainTileVec.equals(absolute)) {
                for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
                    StructureRelative relativeST = relative.getRelative(this);
                    if (relativeST == null) continue;
                    relativeST.onMove(this, vec.getContext(), vec.getVec());
                }
            }
        }
        this.lastMainTileVec = absolute;
        this.updateStructure();
    }

    public boolean doesLinkToMainTile(LittleTile tile) {
        try {
            return tile == this.getMainTile() || tile.connection.isLink() && tile.connection.getStructurePosition().equals((Object)this.mainTile.getBlockPos()) && tile.connection.is(this.mainTile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean loaded() {
        return this.mainTile != null && this.tiles != null && (this.tilesToLoad == null || this.tilesToLoad.size() == 0) && !this.isRelationToParentBroken() && !this.isRelationToChildrenBroken();
    }

    protected void checkLoaded() {
        if (!this.loaded()) {
            throw new RuntimeException("Structure is not loaded cannot add tile!");
        }
    }

    protected boolean checkForTiles(World world, BlockPos pos, Integer expectedCount) {
        TileEntity tileEntity;
        Chunk chunk = world.func_175726_f(pos);
        if (WorldUtils.checkIfChunkExists((Chunk)chunk) && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityLittleTiles) {
            if (!((TileEntityLittleTiles)tileEntity).hasLoaded()) {
                return false;
            }
            int found = 0;
            if (this.tiles.keySet().contains(pos)) {
                this.tiles.removeKey((Object)pos);
            }
            for (LittleTile tile : (TileEntityLittleTiles)tileEntity) {
                if (!tile.isChildOfStructure() || tile.connection.getStructureWithoutLoading() != this && !this.doesLinkToMainTile(tile)) continue;
                this.tiles.add((Object)pos, (Object)tile);
                if (tile.connection.isLink()) {
                    tile.connection.setLoadedStructure(this);
                }
                ++found;
            }
            if (found == expectedCount) {
                return true;
            }
        }
        return false;
    }

    public boolean load() {
        if (this.mainTile != null) {
            if (this.tiles == null) {
                this.tiles = new HashMapList();
                this.add(this.mainTile);
            }
            if (this.tilesToLoad == null) {
                return !this.isRelationToParentBroken() && !this.isRelationToChildrenBroken();
            }
            Iterator<Map.Entry<BlockPos, Integer>> iterator = this.tilesToLoad.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, Integer> entry = iterator.next();
                if (!this.checkForTiles(this.mainTile.te.func_145831_w(), entry.getKey(), entry.getValue())) continue;
                iterator.remove();
            }
            if (!this.tiles.contains((Object)this.mainTile)) {
                this.add(this.mainTile);
            }
            if (this.tilesToLoad.size() == 0) {
                this.tilesToLoad = null;
            }
            return this.loaded();
        }
        return false;
    }

    @Deprecated
    public void removeTileList() {
        this.tiles = null;
    }

    public void createTilesList() {
        if (this.isStructurePlaced()) {
            throw new RuntimeException("Cannot create list, structure is placed already");
        }
        this.tiles = new HashMapList();
    }

    public List<TileEntityLittleTiles> collectBlocks() {
        if (!this.load()) {
            return Collections.EMPTY_LIST;
        }
        World world = this.getWorld();
        ArrayList<TileEntityLittleTiles> blocks = new ArrayList<TileEntityLittleTiles>(this.tiles.size());
        for (BlockPos pos : this.tiles.keySet()) {
            blocks.add((TileEntityLittleTiles)world.func_175625_s(pos));
        }
        return blocks;
    }

    public HashMapList<BlockPos, LittleTile> copyOfTiles() {
        if (!this.load()) {
            return EMPTY_HASHMAPLIST;
        }
        return new HashMapList(this.tiles);
    }

    public Iterator<LittleTile> getTiles() {
        if (!this.load()) {
            return EMPTY_ITERATOR;
        }
        return this.tiles.iterator();
    }

    public TileEntityLittleTiles loadTE(BlockPos pos) throws MissingTileEntity {
        TileEntity te = this.getWorld().func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityLittleTiles)) {
            throw new MissingTileEntity(pos);
        }
        return (TileEntityLittleTiles)te;
    }

    public HashMapList<BlockPos, LittleTile> blockTiles() {
        if (!this.load()) {
            return EMPTY_HASHMAPLIST;
        }
        return this.tiles;
    }

    public HashMapList<BlockPos, LittleTile> collectBlockTilesChildren(HashMapList<BlockPos, LittleTile> tiles, boolean onlySameWorld) {
        if (!this.load() || !this.loadChildren()) {
            return tiles;
        }
        tiles.addAll(this.tiles);
        for (IStructureChildConnector child : this.children) {
            if (onlySameWorld && child.isLinkToAnotherWorld()) continue;
            child.getStructure(this.getWorld()).collectBlockTilesChildren(tiles, onlySameWorld);
        }
        return tiles;
    }

    public boolean contains(LittleTile tile) {
        return this.tiles.contains((Object)tile.getBlockPos(), (Object)tile);
    }

    public void replace(LittleTile oldTile, LittleTile newTile) {
        this.tiles.removeValue((Object)oldTile.getBlockPos(), (Object)oldTile);
        this.tiles.add((Object)newTile.getBlockPos(), (Object)newTile);
    }

    public void remove(LittleTile tile) {
        this.checkLoaded();
        this.tiles.removeValue((Object)tile.getBlockPos(), (Object)tile);
    }

    public void add(LittleTile tile) {
        this.tiles.add((Object)tile.getBlockPos(), (Object)tile);
    }

    public void combineTiles() {
        if (this.load()) {
            for (TileEntityLittleTiles te : this.collectBlocks()) {
                te.combineTiles(this);
            }
        }
    }

    protected void markToBeLoaded(BlockPos pos) {
        ArrayList tiles = this.tiles.getValues((Object)pos);
        this.tiles.removeKey((Object)pos);
        if (tiles != null && !tiles.isEmpty()) {
            if (this.tilesToLoad == null) {
                this.tilesToLoad = new LinkedHashMap();
            }
            this.tilesToLoad.put(pos, tiles.size());
        }
    }

    public int count() {
        int count = 0;
        if (this.tilesToLoad != null) {
            for (Integer tiles : this.tilesToLoad.values()) {
                count += tiles.intValue();
            }
        }
        if (this.tiles != null) {
            for (Map.Entry entry : this.tiles.entrySet()) {
                if (this.tilesToLoad != null && this.tilesToLoad.containsKey(entry.getKey())) continue;
                count += ((ArrayList)entry.getValue()).size();
            }
        }
        return count;
    }

    public boolean isChildOf(LittleStructure structure) {
        if (this.parent != null && this.parent.isConnected(this.getWorld())) {
            return structure == this.parent.getStructureWithoutLoading() || this.parent.getStructureWithoutLoading().isChildOf(structure);
        }
        return false;
    }

    public LittleIdentifierStructureRelative getMainTileCoord(BlockPos pos) {
        return new LittleIdentifierStructureRelative(pos, this.mainTile.getBlockPos(), this.mainTile.getContext(), this.mainTile.getIdentifier(), this.getAttribute());
    }

    public StructureLinkTile getStructureLink(LittleTile tile) {
        return new StructureLinkTile((TileEntity)tile.te, this.mainTile.getBlockPos(), this.mainTile.getContext(), this.mainTile.getIdentifier(), this.getAttribute(), tile);
    }

    public boolean isRelationToParentBroken() {
        return this.parent != null && !this.parent.isConnected(this.getWorld());
    }

    public boolean isRelationToChildrenBroken() {
        for (IStructureChildConnector child : this.children) {
            if (child.isConnected(this.getWorld())) continue;
            return true;
        }
        return false;
    }

    public void updateChildConnection(int i, LittleStructure child) {
        IStructureChildConnector<LittleStructure> connector;
        World world = this.getWorld();
        World childWorld = child.getWorld();
        if (childWorld == world) {
            connector = new StructureLink((TileEntity)this.mainTile.te, child.getMainTile().getBlockPos(), child.getMainTile().getContext(), child.getMainTile().getIdentifier(), child.getAttribute(), this, i, false);
        } else if (childWorld instanceof SubWorld && ((SubWorld)childWorld).parent != null) {
            connector = new StructureLinkToSubWorld(child.getMainTile(), child.getAttribute(), this, i, ((SubWorld)childWorld).parent.func_110124_au());
        } else {
            throw new RuntimeException("Invalid connection between to structures!");
        }
        connector.setLoadedStructure(child);
        if (this.children.size() > i) {
            this.children.set(i, connector);
        } else if (this.children.size() == i) {
            this.children.add(connector);
        } else {
            throw new RuntimeException("Invalid childId " + this.children.size() + ".");
        }
    }

    public void updateParentConnection(int i, LittleStructure parent) {
        IStructureChildConnector<LittleStructure> connector;
        World world = this.getWorld();
        World parentWorld = parent.getWorld();
        if (parentWorld == world) {
            connector = new StructureLink((TileEntity)this.mainTile.te, parent.getMainTile().getBlockPos(), parent.getMainTile().getContext(), parent.getMainTile().getIdentifier(), parent.getAttribute(), this, i, true);
        } else if (world instanceof SubWorld && ((SubWorld)world).parent != null) {
            connector = new StructureLinkFromSubWorld(parent.getMainTile(), parent.getAttribute(), this, i);
        } else {
            throw new RuntimeException("Invalid connection between to structures!");
        }
        connector.setLoadedStructure(parent);
        this.parent = connector;
    }

    public boolean loadParent() {
        if (this.parent != null) {
            return this.parent.isConnected(this.getWorld());
        }
        return true;
    }

    public boolean loadChildren() {
        if (this.children == null) {
            this.children = new ArrayList<IStructureChildConnector>();
        }
        if (this.children.isEmpty()) {
            return true;
        }
        for (IStructureChildConnector child : this.children) {
            if (child.isConnected(this.mainTile.te.func_145831_w()) && child.getStructureWithoutLoading().load() && child.getStructureWithoutLoading().loadChildren()) continue;
            return false;
        }
        return true;
    }

    public void createTempChildList() {
        this.tempChildren = new ArrayList<LittleStructure>();
    }

    public void addTempChild(LittleStructure child) {
        this.tempChildren.add(child);
    }

    public void placedStructure(@Nullable ItemStack stack) {
        NBTTagCompound nbt;
        if (this.name == null && stack != null && (nbt = stack.func_179543_a("display")) != null && nbt.func_150297_b("Name", 8)) {
            this.name = nbt.func_74779_i("Name");
        }
        this.combineTiles();
        if (this.tempChildren != null) {
            this.children = new ArrayList<IStructureChildConnector>();
            for (int i = 0; i < this.tempChildren.size(); ++i) {
                LittleStructure child = this.tempChildren.get(i);
                child.updateParentConnection(i, this);
                this.updateChildConnection(i, child);
                child.placedStructure(null);
            }
            this.tempChildren = null;
        }
    }

    public void updateStructure() {
        this.mainTile.te.updateBlock();
    }

    public void loadStructure(LittleTile mainTile) {
        this.mainTile = mainTile;
        this.mainTile.connection = new StructureMainTile(mainTile, this);
        if (this.tiles != null && !this.contains(mainTile)) {
            this.add(mainTile);
        }
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        Object pos;
        int i;
        if (this.tiles != null) {
            this.tiles = null;
        }
        this.tilesToLoad = new LinkedHashMap();
        if (nbt.func_74764_b("count")) {
            int count = nbt.func_74762_e("count");
            for (i = 0; i < count; ++i) {
                LittleIdentifierRelative coord = null;
                if (nbt.func_74764_b("i" + i + "coX")) {
                    pos = new LittleTile.LittleTilePosition("i" + i, nbt);
                    coord = new LittleIdentifierRelative((TileEntity)this.mainTile.te, ((LittleTile.LittleTilePosition)pos).coord, LittleGridContext.get(), new int[]{((LittleTile.LittleTilePosition)pos).position.x, ((LittleTile.LittleTilePosition)pos).position.y, ((LittleTile.LittleTilePosition)pos).position.z});
                } else {
                    coord = LittleIdentifierRelative.loadIdentifierOld("i" + i, nbt);
                }
                pos = coord.getAbsolutePosition((TileEntity)this.mainTile.te);
                Integer insideBlock = this.tilesToLoad.get(pos);
                insideBlock = insideBlock == null ? new Integer(1) : Integer.valueOf(insideBlock + 1);
                this.tilesToLoad.put((BlockPos)pos, insideBlock);
            }
            this.tiles = new HashMapList();
        } else if (nbt.func_74764_b("tiles")) {
            NBTTagList list = nbt.func_150295_c("tiles", 11);
            for (i = 0; i < list.func_74745_c(); ++i) {
                int[] array = list.func_150306_c(i);
                if (array.length == 4) {
                    pos = new RelativeBlockPos(array);
                    this.tilesToLoad.put(((RelativeBlockPos)pos).getAbsolutePos((TileEntity)this.mainTile.te), array[3]);
                    continue;
                }
                System.out.println("Found invalid array! " + nbt);
            }
            this.tiles = new HashMapList();
        }
        this.name = nbt.func_74764_b("name") ? nbt.func_74779_i("name") : null;
        this.parent = nbt.func_74764_b("parent") ? StructureLink.loadFromNBT(this, nbt.func_74775_l("parent"), true) : null;
        if (nbt.func_74764_b("children")) {
            this.children = new ArrayList<IStructureChildConnector>();
            NBTTagList list = nbt.func_150295_c("children", 10);
            for (i = 0; i < list.func_74745_c(); ++i) {
                this.children.add(StructureLink.loadFromNBT(this, list.func_150305_b(i), false));
            }
            if (this instanceof IAnimatedStructure && ((IAnimatedStructure)((Object)this)).isAnimated()) {
                for (IStructureChildConnector child : this.children) {
                    if (!(child instanceof StructureLinkToSubWorld) || !((StructureLinkToSubWorld)child).entityUUID.equals(((IAnimatedStructure)((Object)this)).getAnimation().func_110124_au())) continue;
                    throw new RuntimeException("Something went wrong during loading!");
                }
            }
        } else {
            this.children = new ArrayList<IStructureChildConnector>();
        }
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            if (nbt.func_74764_b(relative.saveKey)) {
                relative.createAndSetRelative(this, nbt);
                continue;
            }
            this.failedLoadingRelative(nbt, relative);
        }
        this.loadFromNBTExtra(nbt);
    }

    protected void failedLoadingRelative(NBTTagCompound nbt, LittleStructureType.StructureTypeRelative relative) {
        relative.setRelative(this, null);
    }

    protected abstract void loadFromNBTExtra(NBTTagCompound var1);

    public NBTTagCompound writeToNBTPreview(NBTTagCompound nbt, BlockPos newCenter) {
        nbt.func_74778_a("id", this.type.id);
        if (this.name != null) {
            nbt.func_74778_a("name", this.name);
        } else {
            nbt.func_82580_o("name");
        }
        LittleVecContext vec = this.getMainTile().getAbsolutePos().getRelative(new LittleAbsoluteVec(newCenter, this.getMainTile().getContext()));
        LittleVec inverted = vec.getVec().copy();
        inverted.invert();
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            StructureRelative relativeST = relative.getRelative(this);
            if (relativeST == null) continue;
            relativeST.onMove(this, vec.getContext(), vec.getVec());
            relativeST.writeToNBT(relative.saveKey, nbt);
            relativeST.onMove(this, vec.getContext(), inverted);
        }
        this.writeToNBTExtra(nbt);
        return nbt;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("id", this.type.id);
        if (this.name != null) {
            nbt.func_74778_a("name", this.name);
        } else {
            nbt.func_82580_o("name");
        }
        if (this.parent != null) {
            nbt.func_74782_a("parent", (NBTBase)this.parent.writeToNBT(new NBTTagCompound()));
        }
        if (this.children != null && !this.children.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (IStructureChildConnector<Object> iStructureChildConnector : this.children) {
                list.func_74742_a((NBTBase)iStructureChildConnector.writeToNBT(new NBTTagCompound()));
            }
            nbt.func_74782_a("children", (NBTBase)list);
        }
        HashMap positions = new HashMap();
        if (this.tiles != null) {
            for (Map.Entry entry : this.tiles.entrySet()) {
                if (((ArrayList)entry.getValue()).size() <= 0) continue;
                positions.put(entry.getKey(), ((ArrayList)entry.getValue()).size());
            }
        }
        if (this.tilesToLoad != null) {
            positions.putAll(this.tilesToLoad);
        }
        if (positions.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry entry : positions.entrySet()) {
                RelativeBlockPos pos = new RelativeBlockPos((TileEntity)this.mainTile.te, (BlockPos)entry.getKey());
                list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.getRelativePos().func_177958_n(), pos.getRelativePos().func_177956_o(), pos.getRelativePos().func_177952_p(), (Integer)entry.getValue()}));
            }
            nbt.func_74782_a("tiles", (NBTBase)list);
        }
        for (LittleStructureType.StructureTypeRelative structureTypeRelative : this.type.relatives) {
            StructureRelative relativeST = structureTypeRelative.getRelative(this);
            if (relativeST == null) continue;
            relativeST.writeToNBT(structureTypeRelative.saveKey, nbt);
        }
        this.writeToNBTExtra(nbt);
    }

    protected abstract void writeToNBTExtra(NBTTagCompound var1);

    public void addIngredients(LittleIngredients ingredients) {
    }

    public void finializePreview(LittlePreviews previews) {
    }

    public void onLittleTileDestroy() {
        if (this.parent != null) {
            if (this.parent.isConnected(this.getWorld())) {
                this.parent.getStructure(this.getWorld()).onLittleTileDestroy();
            }
            return;
        }
        if (this.load() && this.loadChildren()) {
            this.removeStructure();
        }
    }

    public void removeStructure() {
        this.checkLoaded();
        this.onStructureDestroyed();
        for (IStructureChildConnector child : this.children) {
            child.destroyStructure();
        }
        if (this instanceof IAnimatedStructure && ((IAnimatedStructure)((Object)this)).isAnimated()) {
            ((IAnimatedStructure)((Object)this)).destroyAnimation();
        } else if (this.mainTile.te.contains(this.mainTile)) {
            for (Map.Entry entry : this.tiles.entrySet()) {
                try {
                    this.loadTE((BlockPos)entry.getKey()).updateTiles(x -> x.removeAll((Collection)entry.getValue()));
                }
                catch (MissingTileEntity missingTileEntity) {}
            }
        }
    }

    public void onStructureDestroyed() {
    }

    public LittleGridContext getMinContext() {
        LittleGridContext context = LittleGridContext.getMin();
        for (IStructureChildConnector child : this.children) {
            context = LittleGridContext.max(context, child.getStructure(this.getWorld()).getMinContext());
        }
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            StructureRelative relativeST = relative.getRelative(this);
            if (relativeST == null) continue;
            relativeST.convertToSmallest();
            context = LittleGridContext.max(context, relativeST.getContext());
        }
        return context;
    }

    public LittleAbsolutePreviewsStructure getAbsolutePreviews(BlockPos pos) {
        NBTTagCompound structureNBT = new NBTTagCompound();
        this.writeToNBTPreview(structureNBT, pos);
        LittleAbsolutePreviewsStructure previews = new LittleAbsolutePreviewsStructure(structureNBT, pos, this.getMinContext());
        Iterator<LittleTile> iterator = this.getTiles();
        while (iterator.hasNext()) {
            previews.addTile(iterator.next());
        }
        for (IStructureChildConnector child : this.children) {
            previews.addChild(child.getStructure(this.getWorld()).getPreviews(pos));
        }
        previews.convertToSmallest();
        previews.convertToAtMinimum(this.getMinContext());
        return previews;
    }

    public LittlePreviewsStructure getPreviews(BlockPos pos) {
        NBTTagCompound structureNBT = new NBTTagCompound();
        this.writeToNBTPreview(structureNBT, pos);
        LittlePreviewsStructure previews = new LittlePreviewsStructure(structureNBT, this.getMinContext());
        Iterator<LittleTile> iterator = this.getTiles();
        while (iterator.hasNext()) {
            LittleTile tile = iterator.next();
            LittlePreview preview = previews.addTile(tile);
            preview.box.add(new LittleVec(previews.context, (Vec3i)tile.getBlockPos().func_177973_b((Vec3i)pos)));
        }
        for (IStructureChildConnector child : this.children) {
            previews.addChild(child.getStructure(this.getWorld()).getPreviews(pos));
        }
        previews.convertToSmallest();
        previews.convertToAtMinimum(this.getMinContext());
        return previews;
    }

    public LittleAbsolutePreviewsStructure getAbsolutePreviewsSameWorldOnly(BlockPos pos) {
        NBTTagCompound structureNBT = new NBTTagCompound();
        this.writeToNBTPreview(structureNBT, pos);
        LittleAbsolutePreviewsStructure previews = new LittleAbsolutePreviewsStructure(structureNBT, pos, this.getMinContext());
        Iterator<LittleTile> iterator = this.getTiles();
        while (iterator.hasNext()) {
            previews.addTile(iterator.next());
        }
        for (IStructureChildConnector child : this.children) {
            if (!child.isLinkToAnotherWorld()) {
                previews.addChild(child.getStructure(this.getWorld()).getPreviewsSameWorldOnly(pos));
                continue;
            }
            previews.getStructure().addTempChild(child.getStructure(this.getWorld()));
        }
        previews.convertToSmallest();
        previews.convertToAtMinimum(this.getMinContext());
        return previews;
    }

    public LittlePreviewsStructure getPreviewsSameWorldOnly(BlockPos pos) {
        NBTTagCompound structureNBT = new NBTTagCompound();
        this.writeToNBTPreview(structureNBT, pos);
        LittlePreviewsStructure previews = new LittlePreviewsStructure(structureNBT, this.getMinContext());
        Iterator<LittleTile> iterator = this.getTiles();
        while (iterator.hasNext()) {
            LittleTile tile = iterator.next();
            LittlePreview preview = previews.addTile(tile);
            preview.box.add(new LittleVec(previews.context, (Vec3i)tile.getBlockPos().func_177973_b((Vec3i)pos)));
        }
        for (IStructureChildConnector child : this.children) {
            if (!child.isLinkToAnotherWorld()) {
                previews.addChild(child.getStructure(this.getWorld()).getPreviews(pos));
                continue;
            }
            previews.getStructure().addTempChild(child.getStructure(this.getWorld()));
        }
        previews.convertToSmallest();
        previews.convertToAtMinimum(this.getMinContext());
        return previews;
    }

    public BlockPos.MutableBlockPos getMinPos(BlockPos.MutableBlockPos pos) {
        for (BlockPos tePos : this.tiles.keySet()) {
            pos.func_181079_c(Math.min(pos.func_177958_n(), tePos.func_177958_n()), Math.min(pos.func_177956_o(), tePos.func_177956_o()), Math.min(pos.func_177952_p(), tePos.func_177952_p()));
        }
        for (IStructureChildConnector child : this.children) {
            child.getStructure(this.getWorld()).getMinPos(pos);
        }
        return pos;
    }

    public List<PlacePreview> getSpecialTiles(LittlePreviews previews) {
        if (this.type.relatives.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PlacePreview> placePreviews = new ArrayList<PlacePreview>();
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            StructureRelative relativeST = relative.getRelative(this);
            if (relativeST == null) continue;
            PlacePreview tile = this.getPlacePreview(relativeST, relative, previews);
            if (relativeST.getContext().size < previews.context.size) {
                tile.convertTo(relativeST.getContext(), previews.context);
            }
            placePreviews.add(tile);
        }
        return placePreviews;
    }

    protected PlacePreview getPlacePreview(StructureRelative relative, LittleStructureType.StructureTypeRelative type, LittlePreviews previews) {
        return relative.getPlacePreview(previews, type);
    }

    public void transferChildrenToAnimation(EntityAnimation animation) {
        for (IStructureChildConnector child : this.children) {
            LittleStructure childStructure = child.getStructure(this.getWorld());
            if (child.isLinkToAnotherWorld()) {
                EntityAnimation subAnimation = ((IAnimatedStructure)((Object)childStructure)).getAnimation();
                int l1 = subAnimation.field_70176_ah;
                int i2 = subAnimation.field_70164_aj;
                World world = this.getWorld();
                if (subAnimation.field_70175_ag) {
                    Chunk chunk = world.func_72964_e(l1, i2);
                    if (chunk != null) {
                        chunk.func_76622_b((Entity)subAnimation);
                    }
                    subAnimation.field_70175_ag = false;
                }
                world.field_72996_f.remove((Object)subAnimation);
                subAnimation.setParentWorld((World)animation.fakeWorld);
                animation.fakeWorld.func_72838_d((Entity)subAnimation);
                subAnimation.updateTickState();
                continue;
            }
            childStructure.transferChildrenToAnimation(animation);
        }
    }

    public void transferChildrenFromAnimation(EntityAnimation animation) {
        World parentWorld = animation.fakeWorld.getParent();
        for (IStructureChildConnector child : this.children) {
            LittleStructure childStructure = child.getStructure(this.getWorld());
            if (child.isLinkToAnotherWorld()) {
                EntityAnimation subAnimation = ((IAnimatedStructure)((Object)childStructure)).getAnimation();
                int l1 = subAnimation.field_70176_ah;
                int i2 = subAnimation.field_70164_aj;
                if (subAnimation.field_70175_ag) {
                    Chunk chunk = animation.fakeWorld.func_72964_e(l1, i2);
                    if (chunk != null) {
                        chunk.func_76622_b((Entity)subAnimation);
                    }
                    subAnimation.field_70175_ag = false;
                }
                animation.fakeWorld.field_72996_f.remove((Object)subAnimation);
                subAnimation.setParentWorld(parentWorld);
                parentWorld.func_72838_d((Entity)subAnimation);
                subAnimation.updateTickState();
                continue;
            }
            childStructure.transferChildrenFromAnimation(animation);
        }
    }

    public void transformAnimation(LittleTransformation transformation) {
        for (IStructureChildConnector child : this.children) {
            LittleStructure childStructure = child.getStructure(this.getWorld());
            if (child.isLinkToAnotherWorld()) {
                ((IAnimatedStructure)((Object)childStructure)).getAnimation().transformWorld(transformation);
                continue;
            }
            childStructure.transformAnimation(transformation);
        }
    }

    public void onMove(LittleGridContext context, LittleVec offset) {
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            StructureRelative relativeST = relative.getRelative(this);
            if (relativeST == null) continue;
            relativeST.onMove(this, context, offset);
        }
    }

    public void onFlip(LittleGridContext context, EnumFacing.Axis axis, LittleVec doubledCenter) {
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            StructureRelative relativeST = relative.getRelative(this);
            if (relativeST == null) continue;
            relativeST.onFlip(this, context, axis, doubledCenter);
        }
    }

    public void onRotate(LittleGridContext context, Rotation rotation, LittleVec doubledCenter) {
        for (LittleStructureType.StructureTypeRelative relative : this.type.relatives) {
            StructureRelative relativeST = relative.getRelative(this);
            if (relativeST == null) continue;
            relativeST.onRotate(this, context, rotation, doubledCenter);
        }
    }

    public AxisAlignedBB getSurroundingBox() {
        if (this.load()) {
            return new SurroundingBox(true).add(this.tiles.entrySet()).getSurroundingBox();
        }
        return null;
    }

    public Vec3d getHighestCenterVec() {
        if (this.load()) {
            return new SurroundingBox(true).add(this.tiles.entrySet()).getHighestCenterVec();
        }
        return null;
    }

    public LittleAbsoluteVec getHighestCenterPoint() {
        if (this.load()) {
            return new SurroundingBox(true).add(this.tiles.entrySet()).getHighestCenterPoint();
        }
        return null;
    }

    public ItemStack getStructureDrop() {
        if (this.parent != null) {
            if (this.parent.isConnected(this.getWorld())) {
                return this.parent.getStructure(this.getWorld()).getStructureDrop();
            }
            return ItemStack.field_190927_a;
        }
        if (this.load() && this.loadChildren()) {
            BlockPos.MutableBlockPos pos = this.getMinPos(new BlockPos.MutableBlockPos(this.getMainTile().getBlockPos()));
            ItemStack stack = new ItemStack(LittleTiles.multiTiles);
            LittlePreviewsStructure previews = this.getPreviews((BlockPos)pos);
            LittlePreview.savePreview(previews, stack);
            if (this.name != null) {
                NBTTagCompound display = new NBTTagCompound();
                display.func_74778_a("Name", this.name);
                stack.func_77978_p().func_74782_a("display", (NBTBase)display);
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) throws LittleActionException {
        return false;
    }

    public boolean isBed(IBlockAccess world, BlockPos pos, EntityLivingBase player) {
        return false;
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
    }

    public void onUpdatePacketReceived() {
    }

    public void tick() {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTick(BlockPos pos, double x, double y, double z, float partialTickTime) {
    }

    @SideOnly(value=Side.CLIENT)
    public void getRenderingCubes(BlockPos pos, BlockRenderLayer layer, List<LittleRenderingCube> cubes) {
    }

    public void addCollisionBoxes(BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
    }

    public void neighbourChanged() {
    }

    public boolean canOnlyBePlacedByItemStack() {
        return false;
    }

    public String getStructureDropIdentifier() {
        return null;
    }
}

