/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.LittleTilesConfig;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class LittleActionBoxes
extends LittleAction {
    public LittleBoxes boxes;

    public LittleActionBoxes(LittleBoxes boxes) {
        this.boxes = boxes;
    }

    public LittleActionBoxes() {
    }

    public abstract void action(World var1, EntityPlayer var2, BlockPos var3, IBlockState var4, List<LittleBox> var5, LittleGridContext var6) throws LittleActionException;

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        if (this.boxes.isEmpty()) {
            return false;
        }
        boolean placed = false;
        World world = player.field_70170_p;
        if (LittleTiles.CONFIG.isEditLimited(player) && this.boxes.getSurroundingBox().getPercentVolume(this.boxes.context) > (double)LittleTiles.CONFIG.survival.maxEditBlocks) {
            throw new LittleTilesConfig.NotAllowedToEditException();
        }
        HashMapList<BlockPos, LittleBox> boxesMap = this.boxes.split();
        for (Map.Entry entry : boxesMap.entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            IBlockState state = world.func_180495_p(pos);
            if (!LittleActionBoxes.isAllowedToInteract(world, player, pos, false, EnumFacing.EAST)) {
                if (world.field_72995_K) continue;
                LittleActionBoxes.sendBlockResetToClient(world, (EntityPlayerMP)player, pos);
                continue;
            }
            placed = true;
            this.action(world, player, pos, state, (List)entry.getValue(), this.boxes.context);
        }
        world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return placed;
    }

    public void writeBytes(ByteBuf buf) {
        LittleActionBoxes.writeBoxes(this.boxes, buf);
    }

    public void readBytes(ByteBuf buf) {
        this.boxes = LittleActionBoxes.readBoxes(buf);
    }

    protected LittleActionBoxes assignFlip(LittleActionBoxes action, EnumFacing.Axis axis, LittleAbsoluteBox box) {
        action.boxes = this.boxes.copy();
        action.boxes.flip(axis, box);
        return action;
    }
}

