/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.entity;

import com.creativemd.creativecore.client.rendering.model.BufferBuilderUtils;
import com.creativemd.littletiles.client.render.cache.BlockLayerRenderBuffer;
import com.creativemd.littletiles.client.render.world.LittleChunkDispatcher;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;

public class LittleRenderChunk {
    protected int lastRenderIndex = LittleChunkDispatcher.currentRenderIndex;
    public final BlockPos pos;
    protected final VertexBuffer[] vertexBuffers = new VertexBuffer[BlockRenderLayer.values().length];
    protected BufferBuilder[] tempBuffers = new BufferBuilder[BlockRenderLayer.values().length];
    protected List<BufferBuilder>[] queuedBuffers = new List[BlockRenderLayer.values().length];
    protected boolean[] bufferChanged = new boolean[BlockRenderLayer.values().length];
    private LinkedHashMap<BlockPos, TileEntityLittleTiles> tileEntities = new LinkedHashMap();
    private boolean modified = false;
    private boolean complete = false;
    public int transparencySortedIndex = 0;

    public LittleRenderChunk(BlockPos pos) {
        this.pos = pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderData(TileEntityLittleTiles te) {
        LinkedHashMap<BlockPos, TileEntityLittleTiles> linkedHashMap = this.tileEntities;
        synchronized (linkedHashMap) {
            TileEntityLittleTiles existing = this.tileEntities.get(te.func_174877_v());
            if (existing != null) {
                if (existing != te) {
                    if (te.isEmpty()) {
                        this.tileEntities.remove(te.func_174877_v());
                    } else {
                        this.tileEntities.put(te.func_174877_v(), te);
                    }
                } else if (te.isEmpty()) {
                    this.tileEntities.remove(te.func_174877_v());
                }
                this.modified = true;
            } else {
                if (te.isEmpty()) {
                    return;
                }
                this.tileEntities.put(te.func_174877_v(), te);
                if (!this.modified) {
                    this.addRenderDataInternal(te);
                }
            }
            if (this.modified) {
                this.complete = false;
            }
        }
    }

    private void addRenderDataInternal(TileEntityLittleTiles te) {
        BlockLayerRenderBuffer layers = te.buffer;
        if (layers != null) {
            for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                BlockRenderLayer layer = BlockRenderLayer.values()[i];
                BufferBuilder tempBuffer = layers.getBufferByLayer(layer);
                if (tempBuffer == null) continue;
                if (this.queuedBuffers[i] == null) {
                    this.queuedBuffers[i] = new ArrayList<BufferBuilder>();
                }
                this.queuedBuffers[i].add(tempBuffer);
            }
        }
    }

    public void resortTransparency(int index, float x, float y, float z) {
        if (index == this.transparencySortedIndex) {
            return;
        }
        this.transparencySortedIndex = index;
        int translucentIndex = BlockRenderLayer.TRANSLUCENT.ordinal();
        BufferBuilder builder = this.tempBuffers[translucentIndex];
        if (builder != null) {
            builder.func_181674_a(x, y, z);
            if (this.vertexBuffers[translucentIndex] != null) {
                this.vertexBuffers[translucentIndex].func_177362_c();
            }
            this.vertexBuffers[translucentIndex] = new VertexBuffer(DefaultVertexFormats.field_176600_a);
            this.vertexBuffers[translucentIndex].func_181722_a(this.tempBuffers[translucentIndex].func_178966_f());
        }
    }

    protected void processQueue() {
        for (int i = 0; i < this.queuedBuffers.length; ++i) {
            if (this.queuedBuffers[i] == null || this.queuedBuffers[i].isEmpty()) continue;
            int expand = 0;
            for (BufferBuilder teBuffer : this.queuedBuffers[i]) {
                expand += teBuffer.func_178989_h();
            }
            BufferBuilder tempBuffer = this.tempBuffers[i];
            if (tempBuffer == null) {
                tempBuffer = new BufferBuilder(DefaultVertexFormats.field_176600_a.func_177338_f() * expand + DefaultVertexFormats.field_176600_a.func_177338_f());
                tempBuffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                tempBuffer.func_178969_c((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p());
                this.tempBuffers[i] = tempBuffer;
            } else {
                BufferBuilderUtils.growBufferSmall((BufferBuilder)tempBuffer, (int)(tempBuffer.func_178973_g().func_177338_f() * expand));
            }
            for (BufferBuilder teBuffer : this.queuedBuffers[i]) {
                BufferBuilderUtils.addBuffer((BufferBuilder)tempBuffer, (BufferBuilder)teBuffer);
            }
            this.queuedBuffers[i].clear();
            this.bufferChanged[i] = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadBuffer() {
        LinkedHashMap<BlockPos, TileEntityLittleTiles> linkedHashMap = this.tileEntities;
        synchronized (linkedHashMap) {
            if (this.modified) {
                for (int i = 0; i < this.vertexBuffers.length; ++i) {
                    if (this.vertexBuffers[i] != null) {
                        this.vertexBuffers[i].func_177362_c();
                    }
                    if (this.tempBuffers[i] != null) {
                        this.tempBuffers[i] = null;
                    }
                    if (this.queuedBuffers[i] == null) continue;
                    this.queuedBuffers[i].clear();
                }
                this.modified = false;
                for (TileEntityLittleTiles te : this.tileEntities.values()) {
                    this.addRenderDataInternal(te);
                }
            }
            this.processQueue();
            for (int i = 0; i < this.bufferChanged.length; ++i) {
                if (!this.bufferChanged[i]) continue;
                if (this.vertexBuffers[i] != null) {
                    this.vertexBuffers[i].func_177362_c();
                }
                this.vertexBuffers[i] = new VertexBuffer(DefaultVertexFormats.field_176600_a);
                this.vertexBuffers[i].func_181722_a(this.tempBuffers[i].func_178966_f());
                this.bufferChanged[i] = false;
            }
            if (this.complete) {
                for (int j = 0; j < this.tempBuffers.length; ++j) {
                    if (j == BlockRenderLayer.TRANSLUCENT.ordinal()) continue;
                    this.tempBuffers[j] = null;
                }
                this.complete = false;
            }
            if (this.lastRenderIndex != LittleChunkDispatcher.currentRenderIndex) {
                for (TileEntityLittleTiles te : this.tileEntities.values()) {
                    te.updateQuadCache(this);
                }
                this.tileEntities.clear();
            }
        }
    }

    public VertexBuffer getLayerBuffer(BlockRenderLayer layer) {
        return this.vertexBuffers[layer.ordinal()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markCompleted() {
        LinkedHashMap<BlockPos, TileEntityLittleTiles> linkedHashMap = this.tileEntities;
        synchronized (linkedHashMap) {
            this.complete = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        LinkedHashMap<BlockPos, TileEntityLittleTiles> linkedHashMap = this.tileEntities;
        synchronized (linkedHashMap) {
            for (int i = 0; i < this.vertexBuffers.length; ++i) {
                if (this.vertexBuffers[i] == null) continue;
                this.vertexBuffers[i].func_177362_c();
            }
            this.tileEntities.clear();
        }
    }
}

