/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.mod.optifine;

import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockStateBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ConnectedTexturesModifier {
    private static Class connectedProperties;
    private static Method match;
    private static Method matchMeta;
    private static Method getBlockID;

    public static boolean matches(Object properties, IBlockAccess world, BlockPos pos, IBlockState state) {
        try {
            TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
            if (te != null) {
                for (LittleTile tile : te) {
                    if (!((Boolean)match.invoke(properties, Block.func_176210_f((IBlockState)tile.getBlockState()))).booleanValue()) continue;
                    return true;
                }
                return false;
            }
            return (Boolean)match.invoke(properties, (Integer)getBlockID.invoke((Object)state, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean matches(Object properties, IBlockAccess world, BlockPos pos, int metadata) {
        try {
            TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
            if (te != null) {
                for (LittleTile tile : te) {
                    if (!((Boolean)matchMeta.invoke(properties, Block.func_176210_f((IBlockState)tile.getBlockState()), metadata)).booleanValue()) continue;
                    return true;
                }
                return false;
            }
            return (Boolean)matchMeta.invoke(properties, Block.func_176210_f((IBlockState)world.func_180495_p(pos)), metadata);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isNeighbour(IBlockAccess world, IBlockState state, BlockPos pos) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            Block block = state.func_177230_c();
            int meta = block.func_176201_c(state);
            for (LittleTile tile : te) {
                if (tile.getBlock() != block || tile.getMeta() != meta) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isFullCube(IBlockState state) {
        return state.func_177230_c() instanceof BlockTile;
    }

    static {
        try {
            connectedProperties = Class.forName("net.optifine.ConnectedProperties");
            match = ReflectionHelper.findMethod((Class)connectedProperties, (String)"matchesBlockId", (String)"matchesBlockId", (Class[])new Class[]{Integer.TYPE});
            matchMeta = ReflectionHelper.findMethod((Class)connectedProperties, (String)"matchesBlock", (String)"matchesBlock", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
            getBlockID = ReflectionHelper.findMethod(BlockStateBase.class, (String)"getBlockId", (String)"getBlockId", (Class[])new Class[0]);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

