/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.inventory;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import ru.poopycoders.improvedbackpacks.inventory.IBackpackInventory;
import ru.poopycoders.improvedbackpacks.inventory.containers.ContainerBackpack;
import ru.poopycoders.improvedbackpacks.items.ItemBackpack;

public class InventoryBackpack
implements IBackpackInventory {
    public ItemStack backpack;
    public UUID uuid;
    public NonNullList<ItemStack> items;

    public static InventoryBackpack loadFromBackpack(ItemStack backpack) {
        InventoryBackpack inv = new InventoryBackpack(backpack);
        if (backpack.func_77942_o()) {
            if (backpack.func_77978_p().func_74764_b("Items")) {
                ItemStackHelper.func_191283_b((NBTTagCompound)backpack.func_77978_p(), inv.items);
            }
            if (backpack.func_77978_p().func_186855_b("UUID")) {
                inv.uuid = backpack.func_77978_p().func_186857_a("UUID");
            }
        }
        return inv;
    }

    private InventoryBackpack(ItemStack backpack) {
        this.backpack = backpack;
        this.items = NonNullList.func_191197_a((int)ItemBackpack.getInventorySize(backpack), (Object)ItemStack.field_190927_a);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack is : this.items) {
            if (is.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.items.set(index, (Object)stack);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerBackpack) {
            return ((ContainerBackpack)player.field_71070_bA).isValid(player);
        }
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.backpack.func_82833_r();
        }
        EnumDyeColor color = ItemBackpack.getBackpackDyeColor(this.backpack);
        if (color != null) {
            return "item.backpack." + color.func_176762_d() + ".name";
        }
        return "item.backpack.name";
    }

    public boolean func_145818_k_() {
        return this.backpack.func_82837_s();
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public ItemStack getBackpack() {
        return this.backpack;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public EnumDyeColor getBackpackColor() {
        return ItemBackpack.getBackpackDyeColor(this.backpack);
    }

    public UUID getUUID() {
        return this.uuid;
    }
}

