/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.grue.common.util;

import com.shinoow.grue.Grue;
import java.util.Arrays;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class DimensionData {
    private int minLight;
    private int maxLight;
    private int spawnTimer;
    private int gracePeriod;
    private float wimpDamage;
    private boolean wimpMode;
    private boolean singleGrue;
    private boolean useGracePeriod;
    private boolean spawnAtPlayer;
    private double[] moonPhases;

    public DimensionData() {
    }

    public DimensionData(String ... data) {
        this.spawnTimer = this.parseOrDef(data[1], Grue.spawnTimer);
        this.spawnTimer = MathHelper.func_76125_a((int)this.spawnTimer, (int)1, (int)60);
        this.useGracePeriod = this.parseOrDef(data[2], Grue.useGracePeriod);
        this.gracePeriod = this.parseOrDef(data[3], Grue.gracePeriod);
        this.gracePeriod = MathHelper.func_76125_a((int)this.gracePeriod, (int)1, (int)30);
        this.wimpMode = this.parseOrDef(data[4], Grue.wimpMode);
        this.wimpDamage = this.parseOrDef(data[5], Grue.wimpModeDamage);
        this.wimpDamage = MathHelper.func_76131_a((float)this.wimpDamage, (float)2.0f, (float)100.0f);
        this.moonPhases = !data[6].isEmpty() ? this.parseOrDef(data[6], Grue.moonPhases) : new double[0];
        this.spawnAtPlayer = this.parseOrDef(data[7], Grue.spawnAtPlayer);
        this.singleGrue = this.parseOrDef(data[8], Grue.singleGrue);
        this.minLight = this.parseOrDef(data[9], Grue.minLight);
        this.minLight = MathHelper.func_76125_a((int)this.minLight, (int)0, (int)15);
        this.maxLight = this.parseOrDef(data[10], Grue.maxLight);
        this.maxLight = MathHelper.func_76125_a((int)this.maxLight, (int)0, (int)15);
    }

    private int parseOrDef(String str, int def) {
        int i;
        if (str.equalsIgnoreCase("def")) {
            return def;
        }
        try {
            i = Integer.parseInt(str);
        }
        catch (Exception e) {
            FMLLog.log((String)"Grue", (Level)Level.ERROR, (String)"Failed to parse integer %s, using default instead", (Object[])new Object[]{str});
            i = def;
        }
        return i;
    }

    private boolean parseOrDef(String str, boolean def) {
        boolean b;
        if (str.equalsIgnoreCase("def")) {
            return def;
        }
        try {
            b = Boolean.parseBoolean(str);
        }
        catch (Exception e) {
            FMLLog.log((String)"Grue", (Level)Level.ERROR, (String)"Failed to parse boolean %s, using default instead", (Object[])new Object[]{str});
            b = def;
        }
        return b;
    }

    private float parseOrDef(String str, float def) {
        float f;
        if (str.equalsIgnoreCase("def")) {
            return def;
        }
        try {
            f = Float.parseFloat(str);
        }
        catch (Exception e) {
            FMLLog.log((String)"Grue", (Level)Level.ERROR, (String)"Failed to parse float %s, using default instead", (Object[])new Object[]{str});
            f = def;
        }
        return f;
    }

    private double[] parseOrDef(String str, double[] def) {
        double[] array;
        if (str.equalsIgnoreCase("def")) {
            return def;
        }
        try {
            array = Arrays.stream(str.split(",")).mapToDouble(Double::parseDouble).toArray();
        }
        catch (Exception e) {
            FMLLog.log((String)"Grue", (Level)Level.ERROR, (String)"Failed to parse double array %s, using default instead", (Object[])new Object[]{str});
            array = def;
        }
        return array;
    }

    public int getMinLight() {
        return this.minLight;
    }

    public int getMaxLight() {
        return this.maxLight;
    }

    public int getSpawnTimer() {
        return this.spawnTimer;
    }

    public int getGracePeriod() {
        return this.gracePeriod;
    }

    public float getWimpDamage() {
        return this.wimpDamage;
    }

    public boolean isWimpMode() {
        return this.wimpMode;
    }

    public boolean isSingleGrue() {
        return this.singleGrue;
    }

    public boolean shouldUseGracePeriod() {
        return this.useGracePeriod;
    }

    public boolean shouldSpawnAtPlayer() {
        return this.spawnAtPlayer;
    }

    public double[] getMoonPhases() {
        return this.moonPhases;
    }
}

